var PopupSearch = Class.create();



PopupSearch.prototype = {



	initialize: function(id, openFunc, closeFunc)

	{

		document.currentMenu = "";



		if(!$(id))

		{

			return false;

		}

		this.id = id;

		var element = $(id);

		

		var popupMenu = element.id+"_popup";

		if(!$(popupMenu))

		{

			return false;

		}

		

		this.menu = $(popupMenu);

		

		if(openFunc)

			this.openFunc = openFunc;

		if(closeFunc)

			this.closeFunc = closeFunc;

		

		this.mouseHovered = false;

		document.lockMenu = false;

		this.menu.style.display = "none";

		element.onclick = this.openMenu.bindAsEventListener(this);

		this.menu.onmouseover = this.mouseOver.bindAsEventListener(this);

		this.menu.onmouseout = this.mouseOut.bindAsEventListener(this);

	},

	

	mouseOver: function(e)

	{

		if(document.currentMenu == this.id)

			this.mouseHovered = true;

	},

	mouseOut: function(e)

	{

		if(document.currentMenu == this.id)

			this.mouseHovered = false;

	},

	

	openMenu: function(e)

	{

		Event.stop(e);

		//this.mouseHovered = false;

		if(document.lockMenu) return;

		if(document.currentMenu == this.id)

		{

			this.closeMenu(document.currentMenu);

			return false;

		}

		else if(document.currentMenu != "")

		{

			this.closeMenu(document.currentMenu);

		}

		

		offsetTop = offsetLeft = 0;

		var element = $(this.id);

		do

		{

			offsetTop += element.offsetTop || 0;

			offsetLeft += element.offsetLeft || 0;

			element = element.offsetParent;

		} while(element);

		element = $(this.id);

		this.menu.style.position = "absolute";

		this.menu.style.zIndex = 100;

		this.menu.style.top = (offsetTop+element.offsetHeight-1)+"px";

		// Bad browser detection - yes, only choice - yes.

		if(MyBB.browser == "opera" || MyBB.browser == "safari")

		{

			this.menu.style.top = (parseInt(this.menu.style.top)-2)+"px";

		}

		this.menu.style.left = offsetLeft+"px";

		this.menu.style.visibility = 'hidden';

		this.menu.style.display = '';

		if(this.menu.style.width)

		{

			menuWidth = parseInt(this.menu.style.width);

		}

		else

		{

			menuWidth = this.menu.offsetWidth;

		}

		if(this.menu.style.height)

		{

			menuHeight = parseInt(this.menu.style.height);

		}

		else

		{

			// doesn't work properly :( :(

			menuHeight = this.menu.offsetHeight;

		}

		pageSize = DomLib.getPageSize();

		if(offsetLeft+menuWidth >= pageSize[0])

		{

			this.menu.style.left = (offsetLeft-menuWidth-2)+"px";

			if(MyBB.browser == "ie")

			{

				this.menu.style.left = (parseInt(this.menu.style.left)-2)+"px";

			}

		}

		if(offsetTop+menuHeight >= pageSize[1] - 2)

		{

			this.menu.style.top = (offsetTop-menuHeight)+"px";

			if(MyBB.browser == "ie")

			{

				this.menu.style.top = (parseInt(this.menu.style.top)-2)+"px";

			}

		}

		this.menu.style.display = '';	

		this.menu.style.visibility = 'visible';



		fadeInElement(this.menu.id, 0, 0.3, 1);

		document.currentMenu = element.id;

		//Event.observe(document, 'click', this.closeMenu.bindAsEventListener(this));

		document.onclick = this.closeMenu.bindAsEventListener(this);

		

		if(this.openFunc)

			this.openFunc();

	},

	

	closeMenu: function()

	{

		if(!this.mouseHovered && document.currentMenu && !document.lockMenu)

		{

			menu = document.currentMenu;

			menu = $(menu+"_popup");

			fadeOutElement(document.currentMenu+"_popup", 1, 0.3, 0, function(){

				menu.style.display = "none";

			});

			document.currentMenu = "";

			document.onclick = function() { };

			

			if(this.closeFunc)

				this.closeFunc();

		}

	}

};



function fadeInElement(elemId, alpha, rate, targetAlpha, completeFunc)

{

	if((alpha += rate) > targetAlpha) alpha = targetAlpha;

	setOpacity(document.getElementById(elemId), alpha);

	if(alpha < targetAlpha)

		setTimeout(function(){fadeInElement(elemId, alpha, rate, targetAlpha, completeFunc);}, 75);

	else if(completeFunc)

		completeFunc();

}



function fadeOutElement(elemId, alpha, rate, targetAlpha, completeFunc)

{

	if((alpha -= rate) < targetAlpha) alpha = targetAlpha;

	setOpacity(document.getElementById(elemId), alpha);

	if(alpha > targetAlpha)

		setTimeout(function(){fadeOutElement(elemId, alpha, rate, targetAlpha, completeFunc);}, 75);

	else if(completeFunc)

		completeFunc();

}



// this function copied and modified from effects.js

function setOpacity(element, value)

{

	if (value == 1)

	{

		element.style.opacity = (/Gecko/.test(navigator.userAgent) && !/Konqueror|Safari|KHTML/.test(navigator.userAgent)) ? 0.999999 : null;

		if(/MSIE/.test(navigator.userAgent))

			element.style.filter = element.style.filter.replace(/alpha\([^\)]*\)/gi,'');  

	}

	else

	{

		if(value < 0.00001) value = 0;

		element.style.opacity = value;

		if(/MSIE/.test(navigator.userAgent))  

			element.style.filter = element.style.filter.replace(/alpha\([^\)]*\)/gi,'') +"alpha(opacity="+value*100+")";

	}

}

