<?php
/**
 * QuickQuote
 * Copyright 2011 Aries-Belgium
 *
 * $Id$
 */

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

DEFINE('QUICKQUOTE_VERSION', 1000);

$plugins->add_hook('showthread_start', 'quickquote_js');
$plugins->add_hook('postbit', 'quickquote_postbit');
$plugins->add_hook('xmlhttp', 'quickquote_xmlhttp');
$plugins->add_hook('usercp_options_start', 'quickquote_usercp');
$plugins->add_hook('usercp_do_options_end', 'quickquote_options_save');

/**
 * Info function for MyBB plugin system
 */
function quickquote_info()
{	
	global $lang;
	
	quickquote__lang_load();
	
	$donate_button = 
'<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RQNL345SN45DS" style="float:right;margin-top:-8px;padding:4px;" target="_blank"><img src="https://www.paypalobjects.com/WEBSCR-640-20110306-1/en_US/i/btn/btn_donate_SM.gif" /></a>';

	return array(
		"name"			=> $lang->quickquote,
		"description"	=> $donate_button.$lang->quickquote_description,
		"website"		=> "",
		"author"		=> "Aries-Belgium",
		"authorsite"	=> "http://community.mybb.com/user-3840.html",
		"version"		=> "1.0",
		"guid" 			=> "64504f1169437d395a7334a83f6fb0d7",
		"compatibility" => "14*,16*"
	);
}

/**
 * The installation function for the plugin system
 */
function quickquote_install()
{
	global $db, $lang;
	
	quickquote__lang_load();
	
	// install the custom templates
	quickquote_templates("install");
	
	// create the qqjump and qqreplace field in the users table
	$db->query("ALTER TABLE ".TABLE_PREFIX."users ADD COLUMN qqjump TINYINT(1) UNSIGNED NOT NULL DEFAULT '1'");
	$db->query("ALTER TABLE ".TABLE_PREFIX."users ADD COLUMN qqreplace TINYINT(1) UNSIGNED NOT NULL DEFAULT '0'");
}

/**
 * The is installed function for the plugin system
 */
function quickquote_is_installed()
{
	global $db;
	
	// does the qqjump and qqreplace exists in the user table?
	if(
		$db->field_exists('qqjump', 'users') &&
		$db->field_exists('qqreplace', 'users')
	)
	{
		return true;
	}
}

/**
 * The uninstall function for the plugin system
 */
function quickquote_uninstall()
{
	global $db;
	
	// remove the custom templates
	quickquote_templates("uninstall");
	
	// remove the qqjump and qqreplace field from the users table
	$db->query("ALTER TABLE ".TABLE_PREFIX."users DROP COLUMN qqjump");
	$db->query("ALTER TABLE ".TABLE_PREFIX."users DROP COLUMN qqreplace");
}

/**
 * The activation function for the plugin system
 */
function quickquote_activate()
{
	quickquote_templates("update");
	
	require_once(MYBB_ROOT."inc/adminfunctions_templates.php");
	find_replace_templatesets("postbit", "#(".preg_quote("{\$post['button_multiquote']}").")#", "$1{\$post['button_quickquote']}");
	find_replace_templatesets("postbit_classic", "#(".preg_quote("{\$post['button_multiquote']}").")#", "$1{\$post['button_quickquote']}");
	find_replace_templatesets("showthread", "#(".preg_quote("</head>").")#", "{\$quickquote_js}\n$1");
	find_replace_templatesets("usercp_options", "#(".preg_quote('{$pppselect}').")#", "{\$qqoptions}\n$1");
}

/**
 * The deactivation function for the plugin system
 */
function quickquote_deactivate()
{
	require_once(MYBB_ROOT."inc/adminfunctions_templates.php");
	find_replace_templatesets("postbit", "#(".preg_quote("{\$post['button_quickquote']}").")#", "", 0);
	find_replace_templatesets("postbit_classic", "#(".preg_quote("{\$post['button_quickquote']}").")#", "", 0);
	find_replace_templatesets("showthread", "#(".preg_quote("{\$quickquote_js}\n").")#", "", 0);
	find_replace_templatesets("usercp_options", "#(".preg_quote('{$qqoptions}'."\n").")#", "", 0);
}

/**
 * Templates
 */
function quickquote_templates($op)
{
	global $db, $mybb;
	
	$templates_version = $mybb->version_code.".".QUICKQUOTE_VERSION;
	
	$templates = array();
	
	$templates[] = array(
		'title' => "postbit_quickquote",
		'template' => $db->escape_string(
'<a href="javascript:Thread.quickQuote({$post[\'pid\']},\'{$post[\'username\']}\',{$post[\'dateline\']});" style="display: none;" id="quickquote_link_{$post[\'pid\']}"><img src="{$post[\'quickquote_img\']}" alt="{$lang->postbit_quickquote}" title="{$lang->postbit_quickquote}" id="quickquote_{$post[\'pid\']}" /></a>
<script type="text/javascript">
//<!--
	$(\'quickquote_link_{$post[\'pid\']}\').style.display = \'\';
// -->
</script>'
		),
		'sid' => -2,
		'version' => $templates_version,
		'status' => '',
		'dateline' => TIME_NOW
	);
	
	$templates[] = array(
		'title' => "usercp_options_quickquote",
		'template' => $db->escape_string(
'<tr>
<td valign="top" width="1"><input type="checkbox" class="checkbox" name="qqreplace" id="qqreplace" value="1" {$qqreplacecheck} /></td>
<td><span class="smalltext"><label for="qqreplace">{$lang->quickquote_replacequote}</label></span></td>
</tr>
<tr>
<td valign="top" width="1"><input type="checkbox" class="checkbox" name="qqjump" id="qqjump" value="1" {$qqjumpcheck} /></td>
<td><span class="smalltext"><label for="qqjump">{$lang->quickquote_jumpto}</label></span></td>
</tr>
'			
		),
		'sid' => -2,
		'version' => $templates_version,
		'status' => '',
		'dateline' => TIME_NOW
	);
	
	switch($op)
	{
		case "install":
			foreach($templates as $template)
			{
				$db->insert_query("templates", $template);
			}
			break;
		case "update":
			foreach($templates as $template)
			{
				$query = $db->simple_select("templates", "tid, sid, version", "title='".$db->escape_string($template['title'])."' AND sid=-2", array('limit'=>1));
				if($db->num_rows($query) > 0)
				{
					$t = $db->fetch_array($query);
					if($template['template'] == $t['template'])
					{
						continue;
					}
					
					$update = array(
						'template' => $template['template'],
						'version' => $template['version'],
						'dateline' => $template['dateline'],
						'status' => $template['status']
					);
					$db->update_query("templates", $update, "tid={$t['tid']}");
				}
				else
				{
					$db->insert_query("templates", $template);
				}
			}
			break;
		case "uninstall":
			foreach($templates as $template)
			{
				$db->delete_query("templates", "title='".$db->escape_string($template['title'])."'");
			}
			break;
	}
}

/**
 * Implementation of the 'showthread_start' hook
 *
 * Append the javascript to the head
 */
function quickquote_js()
{
	global $quickquote_js, $mybb, $cache, $forumpermissions, $thread, $fid, $forum;
	
	if(!($forumpermissions['canpostreplys'] != 0 && $mybb->user['suspendposting'] != 1 && ($thread['closed'] != 1 || is_moderator($fid)) && $mybb->settings['quickreply'] != 0 && $mybb->user['showquickreply'] != '0' && $forum['open'] != 0))
	{
		return;
	}
	
	$smilies = $cache->read("smilies");
	foreach($smilies as $smiley)
	{
		$smiley['fullurl'] = $mybb->settings['bburl'] . "/" . $smiley['image'];
		$smilies_json .= "\"{$smiley['fullurl']}\": \"{$smiley['find']}\",";
	}
	// delete trailing comma
	$smilies_json = substr($smilies_json, 0, -1);
	$smilies_json = "{".$smilies_json."}";
	
	$quickquote_js =
		'<script type="text/javascript" src="'.$mybb->settings['bburl'].'/inc/plugins/quickquote/jscript/Thread.quickquote.js?v='.QUICKQUOTE_VERSION.'"></script>'."\n"
		.'<script type="text/javascript">'
			.'var MYBB_PATH = "'.$mybb->settings['bburl'].'"; '
			.'var MYBB_SMILIES = '.$smilies_json.';'
			.'var QQJUMP = '.($mybb->user['qqjump'] == 1 ? 'true' : 'false').';'
		.'</script>';
}

/**
 * Implementation of the 'postbit' hook
 *
 * Place the quick quote button in the postbit
 */
function quickquote_postbit(&$post)
{
	global $theme, $templates, $mybb, $qq_image, $lang, $forumpermissions, $thread, $fid, $forum;
	
	if(!($forumpermissions['canpostreplys'] != 0 && $mybb->user['suspendposting'] != 1 && ($thread['closed'] != 1 || is_moderator($fid)) && $mybb->settings['quickreply'] != 0 && $mybb->user['showquickreply'] != '0' && $forum['open'] != 0))
	{
		return;
	}
	
	quickquote__lang_load("",true,true);
	
	
	if($mybb->user['qqreplace'] == 1)
	{
		$post['button_quote'] = str_replace('<a', '<a id="quote_'.$post['pid'].'"', $post['button_quote']);
		$post['button_quote'] = str_replace('</a>', '</a>
		<script type="text/javascript">//<!--
		$(\'quote_'.$post['pid'].'\').observe("click", function(event){ Thread.quickQuote('.$post['pid'].', "'.$post['username'].'", '.$post['dateline'].'); Event.stop(event); });
		//-->
		</script>', $post['button_quote']);
	}
	else
	{
		if(!isset($qq_image) || is_null($qq_image))
		{
			$possible_filenames = array(
				$theme['imglangdir']."/postbit_quickquote.png",
				$theme['imglangdir']."/postbit_quickquote.gif",
				$theme['imglangdir']."/postbit_multiquote.png",
				$theme['imglangdir']."/postbit_multiquote.gif",
			);
			
			foreach($possible_filenames as $filename)
			{
				if(file_exists(MYBB_ROOT."/".$filename))
				{
					$qq_image = $mybb->settings['bburl']."/".$filename;
					break;
				}
			}
		}
		
		$post['quickquote_img'] = $qq_image;
		eval("\$post['button_quickquote'] = \"" . $templates->get("postbit_quickquote") . "\";");
	}
}

/**
 * Implementation of the 'usercp_start' hook
 * 
 * Show the quick quote options
 */
function quickquote_usercp()
{
	global $mybb, $lang, $templates, $qqoptions;
	
	quickquote__lang_load();
	
	$qqjumpcheck = $mybb->user['qqjump'] == 1 ? 'checked="checked"' : '';
	$qqreplacecheck = $mybb->user['qqreplace'] == 1 ? 'checked="checked"' : '';
	eval("\$qqoptions = \"".$templates->get("usercp_options_quickquote")."\";");
}

/**
 * Implementation of the 'usercp_do_options_end' hook
 * 
 * Save the quick quote options option
 */
function quickquote_options_save($datahandler)
{
	global $db, $mybb;
	
	$uid = intval($mybb->user['uid']);
	$update = array(
		'qqjump' => intval($mybb->input['qqjump']),
		'qqreplace' => intval($mybb->input['qqreplace'])
	);
	$db->update_query('users', $update, 'uid='.$uid);
}

/**
 * Implementation of the 'xmlhttp' hook
 *
 * Handle the ajax request
 */
function quickquote_xmlhttp()
{
	global $mybb, $db, $lang;
	
	switch($mybb->input['action'])
	{
		case 'quickquote':
			quickquote__lang_load();
			
			header("Content-Type: application/json");
			$post = get_post(intval($mybb->input['pid']));
			if($post)
			{
				$thread = get_thread($post['tid']);
				$forum = get_forum($post['fid']);
				$forumpermissions = forum_permissions($forum['fid']);
				
				// forum permissions
				if($forumpermissions['canview'] != 1 || $forumpermissions['canviewthreads'] != 1)
				{
					die('{ "error":1, "errstr":"'.$lang->quickquote_error_no_permission.'" }');
				}

				if($forumpermissions['canonlyviewownthreads'] == 1 && $thread['uid'] != $mybb->user['uid'])
				{
					die('{ "error":1, "errstr":"'.$lang->quickquote_error_no_permission.'" }');
				}
				
				$json = "{ \"pid\": {$post['pid']}, \"username\": \"{$post['username']}\", \"dateline\": {$post['dateline']}, \"message\": \"" . addcslashes($post['message'] , "\"\r\n") . "\"";
				$json .= " }";
				
				die($json);
			}
			
			die('{ "error":1, "errstr":"'.$lang->quickquote_error_invalid_post.'" }');
		break;
	}
}
 
/**
 * Helper function to load language files for the plugin
 */
function quickquote__lang_load($file="", $supress_error=false, $force_admin=false)
{
	global $lang;
	
	$plugin_name = str_replace('__lang_load', '', __FUNCTION__);
	$plugin_lang_dir = MYBB_ROOT."inc/plugins/{$plugin_name}/language/";
	if(empty($file)) $file = $plugin_name;
	
	$langparts = explode("/", $lang->language, 2);
	$language = $langparts[0];
	if(isset($langparts[1]))
	{
		$dir = "/".$langparts[1];
	}
	else
	{
		$dir = "";
	}
	
	if($force_admin)
	{
		$dir = "/admin";
	}
	
	if(file_exists($plugin_lang_dir.$language.$dir."/{$file}.lang.php"))
	{
		require_once $plugin_lang_dir.$language.$dir."/{$file}.lang.php";
	}
	elseif(file_exists($plugin_lang_dir."english".$dir."/{$file}.lang.php"))
	{
		require_once $plugin_lang_dir."english".$dir."/{$file}.lang.php";
	}
	else
	{
		if($supress_error != true)
		{
			die($plugin_lang_dir."english".$dir."/{$file}.lang.php");
		}
	}
	
	if(is_array($l))
	{
		foreach($l as $key => $val)
		{
			if(empty($lang->$key) || $lang->$key != $val)
			{
				$lang->$key = $val;
			}
		}
	}
}