﻿<?php
/**
* Author: doodoo
* Copyright: © 2012 doodoo
* Website: http://www.mybbiran.com
* License: http://www.mybbiran.com
**/

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

// Plugin hook
$plugins->add_hook("global_start", "Search_run");

// Plugin info
function Search_info()
{
	return array(
		"name"			=> "هاك مربع البحث",
		"description"	=> "يقوم باضافة مربع للبحث في الهيدر يساعدك بالبحث بجميع اقسام المنتدي.",
		"website"		=> "http://www.mybbiran.com",
		"author"		=> "doodoo for mybb iran ",
		"authorsite"	=> "http://community.mybbiran.com/user-2917.html",
		"version"		=> "1.0",
        "guid"          => intval($gid),
		"compatibility" => "1*"
	);

}

function Search_install()
{
	global $db, $mybb;

	$my_setting_group = array(
		'gid'			=> 'NULL',
		'name' 			=> 'doodoo_Setting_Group_Search',
		'title'			=> 'هاك مربع البحث',
		'description'		=> 'اعدادات الهاك',
		'disporder'		=> 3,
		'isdefault'		=> 0
	);
    
	
	$db->insert_query("settinggroups",$my_setting_group);
	$gid = $db->insert_id();
	
	$my_input = array(
		'sid' 			=> 'NULL',
		'name'			=> 'doodoo_Input_Search',
		'title'			=> 'الجملة الافتراضية',
		'description'		=> 'الجملة الافتراضية التي تظهر في مربع البحث',
		'optionscode' 		=> 'text',
		'value'			=> 'ابحث هنا',
		'disporder'		=> 1,
		'gid'			=> intval($gid)
	);
	
	$db->insert_query("settings", $my_input);
	
	$my_forum_ids = array(
		'sid'			=> 'NULL',
		'name'			=> 'doodoo_Forum_IDS_Search',
		'title'			=> 'ايدي الفورم',
		'description'		=> 'ادخل ايدي الفورم التي تريد ان يتم البحث به فقط او ادخل 0 ليتم البحث في الجميع',
		'optionscode'		=> 'text',
		'value'			=> '0',
		'disporder'		=> 2,
		'gid'			=> intval($gid)
	);
	
	$db->insert_query("settings", $my_forum_ids);
	
		$my_doodoo_Size_Search = array(
		'sid'			=> 'NULL',
		'name'			=> 'doodoo_Size_search',
		'title'			=> 'حجم المربع',
		'description'		=> 'ادخل حجم مربع البحث',
		'optionscode'		=> 'text',
		'value'			=> '20',
		'disporder'		=> 3,
		'gid'			=> intval($gid)
	);
	
	$db->insert_query("settings", $my_doodoo_Size_Search);
	
		$my_doodoo_image = array(
		'sid'			=> 'NULL',
		'name'			=> 'doodoo_image',
		'title'			=> 'رابط الايقونة',
		'description'		=> 'يتم اضافة رابط ايقونة البحث',
		'optionscode'		=> 'text',
		'value'			=> 'images/submit.gif',
		'disporder'		=> 4,
		'gid'			=> intval($gid)
	);
	
	$db->insert_query("settings", $my_doodoo_image);
	
	$db->write_query("ALTER TABLE ".TABLE_PREFIX."users ADD doodoo_Search int NOT NULL default 0");
	
	rebuild_settings();
}


function Search_uninstall()
{
	global $db;

	if($db->field_exists('doodoo_Search', "users")) $db->write_query("ALTER TABLE ".TABLE_PREFIX."users DROP doodoo_Search");

	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='doodoo_Setting_Group_Search'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='doodoo_Input_Search'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='doodoo_Forum_IDS_Search'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='doodoo_Size_search'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='doodoo_image'");

	rebuild_settings();
}

function Search_is_installed()
{
	global $db;

	$result = ($db->field_exists('doodoo_Search', "users")) ? TRUE : FALSE;

	return $result;
}

function Search_activate()
{
	include MYBB_ROOT."/inc/adminfunctions_templates.php";

	find_replace_templatesets("header", "#".preg_quote("<navigation>")."#i", "{\$search}<navigation>");
};

function Search_deactivate()
{
	include MYBB_ROOT."/inc/adminfunctions_templates.php";

	find_replace_templatesets("header", "#".preg_quote("{\$search}")."#i", "", 0);
};

function Search_run()
{
	global $search,$mybb;

	$forums=explode(',',$mybb->settings['doodoo_Forum_IDS_Search']);
	$myforums="";	
	
	for ($cnt=0;$cnt<count($forums);$cnt++)
	{
		$thisforumitem = $forums[$cnt];
		$myforums .= "<input type=\"hidden\" name=\"forums[]\" value={$thisforumitem}>";
	}
	
	$search = "";
	$search.= "<right><form action=\"search.php\" method=\"post\" value=\"Search\"><table><tr><td><input type=\"text\" class=\"textbox\" size=\"".$mybb->settings['doodoo_Size_search']."\" style=\"\" name=\"keywords\" onfocus=\"this.value = '';\" value=\"".$mybb->settings['doodoo_Input_search']."\" /></td><td valign=\"middle\"><input type=\"image\" width=\"15px\" height=\"15px\" style=\"margin:0px;padding:0px\" src=\"".$mybb->settings['doodoo_image']."\" border=\"0\"></td></tr></table><input type=\"hidden\" name=\"action\" value=\"do_search\" /><input type=\"hidden\" name=\"postthread\" value=\"1\"/>".$myforums."</right></form></td></tr></tbody></table><br/>";
	return $search;
};

?>