<?php
/**
 * This file is part of Vanillicon plugin for MyBB.
 * This Plugin is a repurposed version of the Gravatar plugin for MyBB (by Andreas Klauer)
 * The Gravatar plugin used is: Copyright (C) 2010 Andreas Klauer <Andreas.Klauer@metamorpher.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
    die("Direct initialization of this file is not allowed.<br /><br />
         Please make sure IN_MYBB is defined.");
}

/* --- Hooks: --- */

$plugins->add_hook("usercp_avatar_start", "vanillicon_usercp_avatar_start");
$plugins->add_hook("usercp_do_avatar_start", "vanillicon_usercp_do_avatar_start");

/* --- Plugin API: --- */

function vanillicon_info()
{
    return array(
        "name"          => "Vanillicon",
        "description"   => "This plugin lets users display their Vanillicon avatar.",
        "website"       => "http://www.vanillicon.com",
        "author"        => "Aventura (Gavin Sealey)",
        "authorsite"    => "mailto:aventura@viper-network.co.uk",
        "version"       => "0.1",
        "guid"          => "60233ca189f07474b74be0edce2785e8",
        "compatibility" => "14*,15*,16*"
        );
}

function vanillicon_deactivate()
{
    global $db;

    require_once MYBB_ROOT."inc/adminfunctions_templates.php";

    find_replace_templatesets('usercp_avatar',
                              "#([\r\n ]*\\{\\\$vanillicon\\}[\r\n ]*)#",
                              "\n",
                              0); // work around MyBB bug

    $db->delete_query("templates", "title='vanillicon'");
}

function vanillicon_activate()
{
    global $db;

    // Remove stuff first to avoid doubling problem.
    vanillicon_deactivate();

    // Insert {$vanillicon} into the usercp_avatar template.
    require_once MYBB_ROOT."inc/adminfunctions_templates.php";

    find_replace_templatesets('usercp_avatar',
                              "#(</table>[\r\n ]*<br />)#i",
                              "\n{\$vanillicon}\n\\1");

    $template = array("title" => "vanillicon",
                      "sid" => "-1",
                      "template" => "
<tr>
<td class=\"trow1\" width=\"40%\">
<strong>{\$lang->vanillicon}</strong>
</td>
<td class=\"trow1\">
<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">
<tbody>
<tr>
<td>
{\$lang->vanillicon_caption}<br />
{\$lang->vanillicon_email}
</td>
<td align=\"right\">
<label><input type=\"checkbox\" name=\"vanillicon\" value=\"1\" /><img align=\"middle\" src=\"{\$vanillicon_url}\" alt=\"{\$lang->vanillicon}\" title=\"{\$lang->vanillicon}\"></label>
</td>
</tr>
</tbody>
</table>
</td>
</tr>
",
        );

    $db->insert_query("templates", $template);
}

/* --- Helpers: --- */

function vanillicon_get_link($email)
{
    return "http://www.vanillicon.com/".md5(trim(my_strtolower($email)));

}

/* --- Functionality: --- */

/*
 * Display a Vanillicon checkbox.
 */
function vanillicon_usercp_avatar_start()
{
    global $mybb, $lang, $templates, $vanillicon;

    $lang->load('vanillicon');

    $lang->vanillicon_email = $lang->sprintf($lang->vanillicon_email,
                                           $mybb->user['email']);

    $vanillicon_url = vanillicon_get_link($mybb->user['email']);

    eval("\$vanillicon = \"".$templates->get("vanillicon")."\";");
}

/*
 * Check if the user checked the Vanillicon box,
 * and then just set the Avatar URL to the Vanillicon URL.
 */
function vanillicon_usercp_do_avatar_start()
{
    global $mybb;

    if($mybb->input['vanillicon'])
    {
        $mybb->input['avatarurl'] = vanillicon_get_link($mybb->user['email']);
    }
}

/* --- End of file. --- */
?>
