<?php
/**
Author: Tommy
Plugin name: MyTwitter
Website: Dev-Network.com
*/

//define no direct access
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

//create hooks
$plugins->add_hook("newthread_do_newthread_end", "mytwitter_tweet");

//include all needed files:
        // include twitter class
        include MYBB_ROOT.'inc/plugins/mytwitter/class.php';
		//include config file
		include MYBB_ROOT.'/inc/plugins/mytwitter/config.php';

//plugin info
function mytwitter_info()
{
    return array(
        "name"            => "هاك ارسال المواضيع لتويتر",
        "description"    => "يسمح لك بارسال المواضيع بشكل تلقائي الي تويتر",
        "website"        => "http://dev-network.com",
        "author"        => "Tommy",
        "authorsite"    => "http://dev-network.com",
        "version"        => mytwitter_version(),
        "guid"            => "0c6fb35e62f74c65178e7deeef89fda1",
        "compatibility" => "16*",
    );
}

//activation functions
function mytwitter_activate()
{
	global $db;
	
	//create group
	$twitter_group = array(
        "gid"            => "990",
        "title"          => "هاك ارسال المواضيع لتويتر",
        "name"           => "mytwitter",
        "description"    => "اعدادات الهاك",
        "disporder"      => "1",
        "isdefault"      => "0",
	);
	
	$db->insert_query("settinggroups", $twitter_group);
	$gid = $db->insert_id();
	
	//create username setting
	$mytwitter_user = array(
		'name'			=> 'mytwitter_user',
		'title'			=> 'اسم العضوية',
		'description'	=> 'ضع اسم العضوية بتويتر',
		'optionscode'	=> 'text',
		'value'			=> '',
		'disporder'		=> '1',
		'gid'			=> intval($gid)
	);

	$db->insert_query('settings', $mytwitter_user);
	
	//create password setting
	$mytwitter_pass = array(
		'name'			=> 'mytwitter_pass',
		'title'			=> 'كلمة المرور ',
		'description'	=> 'كلمة المرور الخاصه بحساب تويتر ',
		'optionscode'	=> 'passwordbox',
		'value'			=> '',
		'disporder'		=> '2',
		'gid'			=> intval($gid)
	);	

	$db->insert_query('settings', $mytwitter_pass);

	//create forums setting
	$mytwitter_forums = array(
		'name'			=> 'mytwitter_forums',
		'title'			=> 'الاقسام المختاره',
		'description'	=> 'ضع ارقام الاقسام المراد نشر المواضيع الجديد بها او اتركها فارغه لنشر جميع الاقسام',
		'optionscode'	=> 'text',
		'value'			=> '',
		'disporder'		=> '3',
		'gid'			=> intval($gid)
	);	
	
	$db->insert_query('settings', $mytwitter_forums);
	
		//create user setting
	$mytwitter_users = array(
		'name'			=> 'mytwitter_users',
		'title'			=> 'الاعضاء المختاره',
		'description'	=> 'ضع ارقام الاعضاء المراد نشر جديد مواضيعهم او اتركها فارغه لنشر مواضيع جميع الاعضاء',
		'optionscode'	=> 'text',
		'value'			=> '',
		'disporder'		=> '3',
		'gid'			=> intval($gid)
	);	
	
	$db->insert_query('settings', $mytwitter_users);
	
	rebuildsettings();
}

//de-activaiton function
function mytwitter_deactivate()
{
	global $db;
	

	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='mytwitter_user'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='mytwitter_pass'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='mytwitter_forums'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='mytwitter_users'");
	$db->delete_query("settinggroups","name='mytwitter'");

	
	rebuildsettings();
}

//actual function for posting API to twitter
function mytwitter_tweet()
{
        global $new_thread, $mybb, $thread_info;

		//check all variables are set
        if ($new_thread['subject'] == "")
		{
			return;
		}
		
		if ($mybb->settings['mytwitter_user'] == "")
		{
			return;
		}
		
		if ($mybb->settings['mytwitter_pass'] == "")
		{
			return;
		}
		
		if ($thread_info['tid'] == "")
		{
			return;
		}
		
        // Get topic URL
        $url = $mybb->settings['bburl'] ."/" . get_thread_link($thread_info['tid']);

		// send twitter status
        $tweet = new twitter($mybb->settings['mytwitter_user'],$mybb->settings['mytwitter_pass']);
		
		//create forum whitelist array
		$forum = $mybb->settings['mytwitter_forums'];
		$forums = explode(",", $forum);
		
		//create user list array
		$user = $mybb->settings['mytwitter_users'];
		$users = explode(",", $user);
		
		
		
		
		//are all users allowed to post?
		if ($user == "")
		{
			//check if forums have been specified
			if($forum == "")
			{
						
				try
				{
    				$tweet->updateStatus($new_thread['username']." posted: ".$new_thread['subject'].": ".$url);

				} 
				catch(TwitterException $exception)
				{
    				return;
				}
			}
		
		
			//check if new thread is in a specified forum
			else if (in_array($new_thread['fid'], $forums))
			{
						
				try
				{
    				$tweet->updateStatus($new_thread['username']." posted: ".$new_thread['subject'].": ".$url);

				} 
				catch(TwitterException $exception)
				{
    				return;
				}		
			}
			
		}
		
		//are certain users allowed to?
		if (in_array($new_thread['uid'], $users))
		{
			//check if forums have been specified
			if($forum == "")
			{
						
				try
				{
    				$tweet->updateStatus($new_thread['username']." posted: ".$new_thread['subject'].": ".$url);

				} 
				catch(TwitterException $exception)
				{
    				return;
				}
			}
		
		
			//check if new thread is in a specified forum
			if (in_array($new_thread['fid'], $forums))
			{
						
				try
				{
    				$tweet->updateStatus($new_thread['username']." posted: ".$new_thread['subject'].": ".$url);

				} 
				catch(TwitterException $exception)
				{
    				return;
				}		
			}
			
		}
		

}

?>