<?php
/**
 * MyStatus
 *
 * @author euantor <admin@xboxgeneration.com>
 * @version 1.0
 * @copyright euantor 2011
 * @package MyStatus
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Disallow Direct Access
if(!defined('IN_MYBB'))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

// Info Function
function mystatus_info()
{
	global $lang;
	$lang->load('mystatus');
	// Information about the plugin
	return array
	(
		'name'			=> $lang->mystatus_info_name,
		'description'	=> $lang->mystatus_info_desc,
		'website'		=> 'http://codicio.us',
		'author'		=> 'euantor / Codicious',
		'authorsite'	=> 'http://euantor.com',
		'version'		=> '1.02',
		'guid'			=> 'efe2b0b1198f4642e842bf2ee546ad74',
		'compatibility'	=> '16*'
	);
}

// Installation Function
function mystatus_install()
{
	global $db, $cache;
	// If the statuses table does not exist, create it
	if (!$db->table_exists('statuses'))
	{
		$db->write_query('CREATE TABLE `'.TABLE_PREFIX.'statuses` (
				`sid` INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
				`uid` INT(10) NOT NULL,
				`status` TEXT NOT NULL,
				`dateline` BIGINT(30) NOT NULL,
				`tweetid` VARCHAR(20) DEFAULT 0
			) ENGINE=MyISAM '.$db->build_create_table_collation().';');
	}
	
	// Usergroup Permissions
    $db->write_query('ALTER TABLE `'.TABLE_PREFIX.'usergroups` ADD `mystatus_can_use` INT(1) NOT NULL DEFAULT \'0\', ADD `mystatus_can_moderate` INT(1) NOT NULL DEFAULT \'0\', ADD `mystatus_can_delete_own` INT(1) NOT NULL DEFAULT \'0\';');
    $db->write_query('UPDATE '.TABLE_PREFIX.'usergroups SET `mystatus_can_delete_own` = 1, `mystatus_can_use` = 1 WHERE gid NOT IN (1, 7);');
    $db->write_query('UPDATE '.TABLE_PREFIX.'usergroups SET `mystatus_can_moderate` = 1 WHERE gid IN (3, 4, 6);');
    $cache->update_usergroups();
	
	// Twitter Oauth user specific settings
	$db->write_query('ALTER TABLE `'.TABLE_PREFIX.'users` ADD `mystatus_twitter_posting_enabled` INT(1) NOT NULL DEFAULT \'0\', ADD `mystatus_twitter_oauth_token` VARCHAR(90), ADD `mystatus_twitter_oauth_token_secret` VARCHAR(90);');
}

// Check to see if MyStatus is installed
function mystatus_is_installed()
{
	global $db;
	return $db->table_exists('statuses');
}

// Activation Function
function mystatus_activate()
{
	global $db, $lang;
	$lang->load('mystatus');
	//Our settings group
	$settingsGroup = array
	(
		'gid'			=> '',
		'name'			=> 'mystatus',
		'title'			=> $lang->mystatus_settings_title,
		'description'	=> $lang->mystatus_settings_desc,
		'disporder'		=> '0',
		'isdefault'		=> '0'
	);
	// Get the gid for the MyStatus settings group
	$gid = intval($db->insert_query('settinggroups', $settingsGroup));
	
	// All of our settings
	$settings = array
	(
		0	=>	array
				(
					'name'			=> 'mystatus_min_length',
					'title'			=> $db->escape_string($lang->mystatus_setting_min_length),
					'description'	=> $db->escape_string($lang->mystatus_setting_min_length_desc),
					'optionscode'	=> 'text',
					'value'			=> '10',
					'disporder'		=> '1',
					'gid'			=> $gid
				),
		1	=>	array
				(
					'name'			=> 'mystatus_max_length',
					'title'			=> $db->escape_string($lang->mystatus_setting_max_length),
					'description'	=> $db->escape_string($lang->mystatus_setting_max_length_desc),
					'optionscode'	=> 'text',
					'value'			=> '140',
					'disporder'		=> '2',
					'gid'			=> $gid
				),
		2	=>	array
				(
					'name'			=> 'mystatus_index_num_recent',
					'title'			=> $db->escape_string($lang->mystatus_setting_index_num_recent),
					'description'	=> $db->escape_string($lang->mystatus_setting_index_num_recent_desc),
					'optionscode'	=> 'text',
					'value'			=> '10',
					'disporder'		=> '3',
					'gid'			=> $gid
				),
		3	=>	array
				(
					'name'			=> 'mystatus_profile_num_recent',
					'title'			=> $db->escape_string($lang->mystatus_setting_profile_num_recent),
					'description'	=> $db->escape_string($lang->mystatus_setting_profile_num_recent_desc),
					'optionscode'	=> 'text',
					'value'			=> '10',
					'disporder'		=> '4',
					'gid'			=> $gid
				),
		4	=>	array
				(
					'name'			=> 'mystatus_post_to_twitter',
					'title'			=> $db->escape_string($lang->mystatus_setting_post_to_twitter),
					'description'	=> $db->escape_string($lang->mystatus_setting_post_to_twitter_desc),
					'optionscode'	=> 'yesno',
					'value'			=> '0',
					'disporder'		=> '5',
					'gid'			=> $gid
				),
		5	=>	array
				(
					'name'			=> 'mystatus_twitter_consumer',
					'title'			=> $db->escape_string($lang->mystatus_setting_twitter_consumer),
					'description'	=> $db->escape_string($lang->mystatus_setting_twitter_consumer_desc),
					'optionscode'	=> 'text',
					'value'			=> '',
					'disporder'		=> '6',
					'gid'			=> $gid
				),
		6	=>	array
				(
					'name'			=> 'mystatus_twitter_consumer_secret',
					'title'			=> $db->escape_string($lang->mystatus_setting_twitter_consumer_secret),
					'description'	=> $db->escape_string($lang->mystatus_setting_twitter_consumer_secret_desc),
					'optionscode'	=> 'text',
					'value'			=> '',
					'disporder'		=> '7',
					'gid'			=> $gid
				)
	);
	// Insert the settings
	foreach ($settings as $setting)
	{
		$query = $db->simple_select('settings', 'COUNT(sid) AS c', 'name = \''.$setting['name'].'\'');
		$count = $db->fetch_field($query, 'c');
		if ($count < 1)
		{
			$db->insert_query('settings', $setting);
		}
		else
		{
			$db->update_query('settings', array('gid' => $gid), 'name = \''.$setting['name'].'\'');
		}
	}
	// Rebuild the settings
	rebuild_settings();
	// Create a MyStatus template group if it doesn't already exist
	$query = $db->simple_select('templategroups', 'COUNT(gid) AS c', "title = '<lang:group_mystatus>'");
    $count = $db->fetch_field($query, 'c');
	if ($count < 1)
	{
		$db->insert_query('templategroups', array('prefix' => 'mystatus', 'title' => '<lang:group_mystatus>'));
	}
	// Then create our templates
	$templates = array
	(
		'mystatus_latest_statuses'		=>	'<table border="0" cellspacing="{$theme[\'borderwidth\']}" cellpadding="{$theme[\'tablespace\']}" class="tborder">
	<thead>
		<tr>
			<td colspan="2" class="thead">
				<strong>{$lang->mystatus_recent_updates}</strong>
			</td>
		</tr>
	</thead>
	<tbody id="latestStatusList">
		{$mystatus_latest_statuses_row}
		{$mystatus_update_form}
	</tbody>
</table>
<br />',
		'mystatus_update_form'			=>	'<tr>
			<td class="{$altbg}" colspan="2">
				<form action="misc.php?action=mystatus_update" method="post" id="mystatusUpdater">
					<div style="padding: {$theme[\'tablespace\']}px">
						<input type="text" name="statusText" id="statusText" value="{$lang->mystatus_enter_prompt}" onfocus="if(this.value == \'{$lang->mystatus_enter_prompt}\') { this.value=\'\'; }" onblur="if(this.value == \'\') { this.value=\'{$lang->mystatus_enter_prompt}\'; }" style="width: 100%" />
						<input type="hidden" name="my_post_key" value="{$mybb->post_code}" id="mystatusPostKey" />
					</div>
				</form>
			</td>
		</tr>',
		'mystatus_latest_statuses_row'	=>	'<tr>
	<td class="{$altbg}" rowspan="2" align="center" width="36">
		<img src="{$status[\'avatar\']}" alt="Avatar of {$status[\'username\']}" width="32" height="32" />
	</td>
	<td class="{$altbg}">
		{$status[\'status\']}
	</td>
</tr>
<tr>
	<td class="{$altbg}">
		<span class="smalltext">
			{$status[\'formattedusername\']} - {$status[\'dateline\']}
		</span>
		<span class="smalltext float_right">
			{$mystatus_button[\'delete\']}
		</div>
	</td>
</tr>',
		'mystatus_latest_statuses_row_no_statuses'	=>	'<tr>
	<td class="trow1" align="center" id="mystatus_no_statuses_to_show">
		{$lang->mystatus_no_statuses}
	</td>
</tr>',
		'mystatus_button_delete'		=>	'<a href="misc.php?action=mystatus_delete&amp;sid={$status[\'sid\']}" id="mystatus_delete_{$status[\'sid\']}">{$lang->mystatus_button_delete}</a>',
		'mystatus_usercp_nav_oauth'		=>	'<tr>
	<td class="trow1 smalltext">
		<a href="usercp.php?action=mystatus-oauth" class="usercp_nav_item usercp_nav_options">{$lang->mystatus_usercp_nav_oauth}</a>
	</td>
</tr>',
		'mystatus_usercp_oauth'			=>	'<html>
	<head>
		<title>{$mybb->settings[\'bbname\']} - {$lang->mystatus_usercp_oauth_title}</title>
		{$headerinclude}
	</head>
	<body>
		{$header}
		<table width="100%" border="0" align="center">
			<tr>
				{$usercpnav}
				<td valign="top">
					<table border="0" cellspacing="{$theme[\'borderwidth\']}" cellpadding="{$theme[\'tablespace\']}" class="tborder">
						<tr>
							<td class="thead" colspan="2"><strong>{$lang->mystatus_usercp_oauth_title}</strong></td>
						</tr>
						<tr>
							<td class="trow1">
								<strong>{$lang->mystatus_usercp_oauth_intro_heading}</strong><br />
								{$lang->mystatus_usercp_oauth_intro_text}<br />
								<br />
								<div style="text-align: center">
									{$mystatus_twitter_link_button}
								</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		{$footer}
	</body>
</html>',
		'mystatus_usercp_oauth_button'	=>	'<a href="usercp.php?action=mystatus-oauth-redirect"><img src="./images/mystatus/twitter.png" alt="{$lang->mystatus_twitter_link_button}" title="{$lang->mystatus_twitter_link_button}" /></a>',
		'mystatus_usercp_oauth_button_deactivate'	=>	'<a href="usercp.php?action=mystatus-oauth-disable"><img src="./images/mystatus/twitter-disconnect.png" alt="{$lang->mystatus_twitter_link_button_disconnect}" title="{$lang->mystatus_twitter_link_button_disconnect}" /></a>'
	);
	// And finally insert said templates into the database
	foreach ($templates as $templateTitle => $templateContent)
	{
		$insertArray = array(
			'title'		=> $db->escape_string($templateTitle),
			'template'	=> $db->escape_string($templateContent),
			'sid'		=> -2,
			'version'	=> 1605,
			'dateline'	=> TIME_NOW
		);
		$db->insert_query('templates', $insertArray);
	}
	
	require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("member_profile", "#".preg_quote('{$signature}')."#i", '{$mystatus_latest_statuses}'."\n".'{$signature}');
	find_replace_templatesets("index", "#".preg_quote('{$boardstats}')."#i", '{$mystatus_latest_statuses}'."\n".'{$boardstats}');
	find_replace_templatesets("headerinclude", "#".preg_quote('{$newpmmsg}')."#i", '{$newpmmsg}'."\n".'{$mystatus_js}');
}

// Deactivation Function
function mystatus_deactivate()
{
	global $db;
	// Delete our settings group and settings
	$gid = $db->fetch_field($db->simple_select('settinggroups', 'gid', 'name=\'mystatus\''), 'gid');
	$db->delete_query('settinggroups', 'gid=\''.$gid.'\'');
	rebuild_settings();
	// Delete our templates
	$db->delete_query('templates', 'title LIKE \'mystatus_%\' AND sid=\'-2\'');
	require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("member_profile", "#".preg_quote('{$mystatus_latest_statuses}'."\n")."#i", '');
	find_replace_templatesets("index", "#".preg_quote('{$mystatus_latest_statuses}'."\n")."#i", '');
	find_replace_templatesets("headerinclude", "#".preg_quote("\n".'{$mystatus_js}')."#i", '');
}

// Uninstallation Function
function mystatus_uninstall()
{
	global $db, $cache;
	// Drop our statuses table and remove the usergroup permission collumns relating to MyStatus
	$db->write_query('DROP TABLE '.TABLE_PREFIX.'statuses');
	$db->write_query("ALTER TABLE `".TABLE_PREFIX."usergroups` DROP `mystatus_can_use`, DROP `mystatus_can_moderate`, DROP `mystatus_can_delete_own`;");
    $cache->update_usergroups();
	
	// Delete our settings
	$db->delete_query('settings', 'name LIKE\'mystatus_%\'');
	
	// Delete our template group
	$db->delete_query('templategroups', 'title = \'<lang:group_mystatus>\'');
	$db->delete_query('templates', 'title LIKE \'mystatus_%\'');
	
	// Delete extra collumns from the users table
	$db->write_query("ALTER TABLE `".TABLE_PREFIX."users` DROP `mystatus_twitter_posting_enabled`, DROP `mystatus_twitter_oauth_token`, DROP `mystatus_twitter_oauth_token_secret`;");
}

// MyStatus Template Set
$plugins->add_hook('admin_style_templates_set', 'mystatus_template_list');
function mystatus_template_list()
{
	global $lang;
	// Need to load the MyStatus language file so the template set will show the correct title
	$lang->load('mystatus');
};

// Usergroups Tab
$plugins->add_hook('admin_user_groups_edit_graph_tabs', 'mystatus_usergroup_perms_tab');
function mystatus_usergroup_perms_tab(&$tabs)
{
	global $lang;
	$lang->load('mystatus');
	// The MyStatus tab within the usergroup modification page
	$tabs['mystatus'] = $lang->group_mystatus;
}

// MyStatus template cache & JS loading
$plugins->add_hook('global_start', 'mystatus_templates_cache');
function mystatus_templates_cache()
{
	global $mybb, $templatelist, $mystatus_js;
	
	if (THIS_SCRIPT == 'member.php' && $mybb->input['action'] == 'profile')
	{
		$templatelist .= ',mystatus_button_delete,mystatus_latest_statuses_row,mystatus_update_form,mystatus_latest_statuses';
		$mystatus_js = "<script type=\"text/javascript\" src=\"{$mybb->settings['bburl']}/jscripts/mystatus.js\"></script>";
	}
	elseif (THIS_SCRIPT == 'index.php')
	{
		$templatelist .= ',mystatus_button_delete,mystatus_latest_statuses_row,mystatus_update_form,mystatus_latest_statuses';
		$mystatus_js = "<script type=\"text/javascript\" src=\"{$mybb->settings['bburl']}/jscripts/mystatus.js\"></script>";
	}
	elseif (THIS_SCRIPT == 'usercp.php' && $mybb->input['action'] == '')
	{
		$templatelist .= ',mystatus_usercp_nav_oauth';
	}
	elseif (THIS_SCRIPT == 'usercp.php' && $mybb->input['action'] == 'mystatus-oauth')
	{
		$templatelist .= ',mystatus_usercp_nav_oauth,mystatus_usercp_oauth_button,mystatus_usercp_oauth';
	}
}

// Usergroups Tab Area
$plugins->add_hook('admin_user_groups_edit_graph', 'mystatus_usergroup_perms');
function mystatus_usergroup_perms()
{
	global $lang, $form, $mybb;
	$lang->load('mystatus');
	// The container for the actual MyStatus permissions
	echo '<div id="tab_mystatus">';
	$form_container = new FormContainer($lang->group_mystatus);
	$form_container->output_row($lang->mystatus_can_use, "", $form->generate_yes_no_radio('mystatus_can_use', $mybb->input['mystatus_can_use'], true), 'mystatus_can_use');
	$form_container->output_row($lang->mystatus_can_moderate, "", $form->generate_yes_no_radio('mystatus_can_moderate', $mybb->input['mystatus_can_moderate'], true), 'mystatus_can_moderate');
	$form_container->output_row($lang->mystatus_can_delete_own, "", $form->generate_yes_no_radio('mystatus_can_delete_own', $mybb->input['mystatus_can_delete_own'], true), 'mystatus_can_delete_own');
	$form_container->end();
	echo '</div>';
}

// Usergroup Permissions Save
$plugins->add_hook('admin_user_groups_edit_commit', 'mystatus_usergroup_perms_save');
function mystatus_usergroup_perms_save()
{
	global $updated_group, $mybb;
	// Get the new information and place it within the $updated_group variable to insert into the database
	$updated_group['mystatus_can_use'] = intval($mybb->input['mystatus_can_use']);
	$updated_group['mystatus_can_moderate'] = intval($mybb->input['mystatus_can_moderate']);
	$updated_group['mystatus_can_delete_own'] = intval($mybb->input['mystatus_can_delete_own']);
}

// Show Twitter OAuth settings in user control panel menu
$plugins->add_hook('usercp_menu', 'mystatus_usercp_nav_oauth', 10);
function mystatus_usercp_nav_oauth()
{
	global $mybb, $templates, $lang, $usercpmenu;
	$lang->load('mystatus');
	// Is the Twitter functionality enabled?
	if ($mybb->settings['mystatus_post_to_twitter'])
	{
		// Add our settings link to the User CP menu
		eval("\$usercpmenu .= \"".$templates->get('mystatus_usercp_nav_oauth')."\";");
	}
}

// Show Twitter OAuth settings page
$plugins->add_hook('usercp_start', 'mystatus_usercp_oauth');
function mystatus_usercp_oauth()
{
	global $mybb, $db, $lang, $templates, $theme, $headerinclude, $header, $footer, $usercpnav, $mystatus_twitter_link_button;
	$lang->load('mystatus');
	// Are the twitter settings even active?
	if ($mybb->settings['mystatus_post_to_twitter'] && $mybb->input['action'] == 'mystatus-oauth')
	{
		if (!$mybb->user['mystatus_twitter_posting_enabled'])
		{
			eval("\$mystatus_twitter_link_button = \"".$templates->get('mystatus_usercp_oauth_button')."\";");
		}
		else
		{
			eval("\$mystatus_twitter_link_button = \"".$templates->get('mystatus_usercp_oauth_button_deactivate')."\";");
		}
		// Get and show the actual page after all that
		eval("\$page = \"".$templates->get('mystatus_usercp_oauth')."\";");
		output_page($page);
	}
	elseif ($mybb->settings['mystatus_post_to_twitter'] && $mybb->input['action'] == 'mystatus-oauth-redirect')
	{
		// Twitter auth stuff.
		session_start();
		require_once MYBB_ROOT.'inc/plugins/mystatus/twitteroauth.php';
		$connection = new TwitterOAuth($mybb->settings['mystatus_twitter_consumer'], $mybb->settings['mystatus_twitter_consumer_secret']);
		$request_token = $connection->getRequestToken($mybb->settings['bburl'].'/usercp.php?action=mystatus-oauth-callback');
		$_SESSION['oauth_token'] = $request_token['oauth_token'];
		$_SESSION['oauth_token_secret'] = $request_token['oauth_token_secret'];
		$url = $connection->getAuthorizeURL($_SESSION['oauth_token']);
		header('Location: '.$url);
	}
	elseif ($mybb->settings['mystatus_post_to_twitter'] && $mybb->input['action'] == 'mystatus-oauth-callback')
	{
		// And more twitter auth stuff.
		session_start();
		require_once MYBB_ROOT.'inc/plugins/mystatus/twitteroauth.php';
		$connection = new TwitterOAuth($mybb->settings['mystatus_twitter_consumer'], $mybb->settings['mystatus_twitter_consumer_secret'], $_SESSION['oauth_token'], $_SESSION['oauth_token_secret']);
		$access_token = $connection->getAccessToken($mybb->input['oauth_verifier']);
		// Finally, we have what we need from Twitter. Let's save this stuff, quick!
		$updateArray = array
		(
			'mystatus_twitter_posting_enabled'		=> 1,
			'mystatus_twitter_oauth_token'			=> $access_token['oauth_token'],
			'mystatus_twitter_oauth_token_secret'	=> $access_token['oauth_token_secret']
		);
		// Oooh yeah, Twitter is setup. Done.
		if($db->update_query('users', $updateArray, 'uid = '.intval($mybb->user['uid'])))
		{
			redirect('usercp.php?action=mystatus-oauth', $lang->mystatus_twitter_link_success);
		}
		else
		{
			error($lang->mystatus_twitter_link_error);
		}
	}
	elseif ($mybb->settings['mystatus_post_to_twitter'] && $mybb->input['action'] == 'mystatus-oauth-disable')
	{
		$updateArray = array
		(
			'mystatus_twitter_posting_enabled'		=>	0
		);
		
		if($db->update_query('users', $updateArray, 'uid = '.intval($mybb->user['uid'])))
		{
			redirect('usercp.php?action=mystatus-oauth', $lang->mystatus_twitter_unlink_success);
		}
		else
		{
			error($lang->mystatus_twitter_unlink_error);
		}
	}
}

// Show Latest Status Updates On Index
$plugins->add_hook('index_start', 'mystatus_index');
function mystatus_index()
{
	global $mybb, $lang, $db, $templates, $theme, $cache, $mystatus_latest_statuses, $mystatus_latest_statuses_row, $altbg, $mystatus_button;
	// make sure we do actually want to show recent statuses on the index
	if (intval($mybb->settings['mystatus_index_num_recent']) != 0)
	{
		$lang->load('mystatus');
		// Grab usergroup's permissions from the cache
		$usergroupsCache = $cache->read('usergroups');
		
		$altbg = 'trow1';
		// Write a query to the database to select the most recent statuses
		$query = $db->write_query('SELECT s.*, u.username, u.avatar, u.usergroup, u.displaygroup FROM '.$db->table_prefix.'statuses s INNER JOIN '.$db->table_prefix.'users u ON u.uid = s.uid ORDER BY sid DESC LIMIT 0, '.intval($mybb->settings['mystatus_index_num_recent']));
		while ($status = $db->fetch_array($query))
		{
			$status['dateline'] = my_date($mybb->settings['dateformat'], $status['dateline']).', '.my_date($mybb->settings['timeformat'], $status['dateline']);
			$status['formattedusername'] = '<a href="'.get_profile_link($status['uid']).'">'.format_name($status['username'], $status['usergroup'], $status['displaygroup']).'</a>';
			// If user is allowed to delete this status, form the delete button
			if (($status['uid'] == $mybb->user['uid'] && $usergroupsCache[$mybb->user['usergroup']]['mystatus_can_delete_own']) || $usergroupsCache[$mybb->user['usergroup']]['mystatus_can_moderate'])
			{
				eval("\$mystatus_button['delete'] = \"".$templates->get('mystatus_button_delete')."\";");
			}
			else
			{
				$mystatus_button['delete'] = '';
			}
			require_once MYBB_ROOT."inc/class_parser.php";
			$parser = new postParser;
			// Set up our parser to output a nice version of the status to be added to the recent updates list
			$parserOptions	=	array
								(
									'allow_html'		=> 0,
									'allow_smilies'		=> 1,
									'allow_mycode'		=> 1,
									'nl2br'				=> 0,
									'filter_badwords'	=> 1,
									'me_username'		=> $status['username'],
									'shorten_urls'		=> 1
								);
			$status['status'] = $parser->parse_message($status['status'], $parserOptions);
			eval("\$mystatus_latest_statuses_row .= \"".$templates->get('mystatus_latest_statuses_row')."\";");
			// Prepare the $altbg variable for the next row
			if ($altbg == 'trow1')
			{
				$altbg = 'trow2';
			}
			else
			{
				$altbg = 'trow1';
			}
		}
		
		if ($db->num_rows($query) == 0)
		{
			eval("\$mystatus_latest_statuses_row = \"".$templates->get('mystatus_latest_statuses_row_no_statuses')."\";");
		}
		if ($altbg == 'trow1')
		{
			$altbg = 'trow2';
		}
		else
		{
			$altbg = 'trow1';
		}
		
		if ($usergroupsCache[$mybb->user['usergroup']]['mystatus_can_use'])
		{
			eval("\$mystatus_update_form = \"".$templates->get('mystatus_update_form')."\";");
		}
		// Finally get the template
		eval("\$mystatus_latest_statuses = \"".$templates->get('mystatus_latest_statuses')."\";");
	}
};

$plugins->add_hook('member_profile_end', 'mystatus_profile');
function mystatus_profile()
{
	global $mybb, $db, $lang, $theme, $templates, $cache, $memprofile, $mystatus_button, $mystatus_latest_statuses_row, $mystatus_update_form, $mystatus_latest_statuses;
	$lang->load('mystatus');
	$usergroupsCache = $cache->read('usergroups');
	
	if (intval($mybb->settings['mystatus_profile_num_recent']) != 0 && $usergroupsCache[$memprofile['usergroup']]['mystatus_can_use'])
	{
		$altbg = 'trow1';
		// Write a query to the database to select the most recent statuses
		$query = $db->simple_select('statuses', '*', 'uid = '.intval($memprofile['uid']), array('order_by' => 'sid', 'order_dir' => 'DESC', 'limit' => $mybb->settings['mystatus_profile_num_recent']));
		while ($status = $db->fetch_array($query))
		{
			$status['dateline'] = my_date($mybb->settings['dateformat'], $status['dateline']).', '.my_date($mybb->settings['timeformat'], $status['dateline']);
			$status['formattedusername'] = '<a href="'.get_profile_link($status['uid']).'">'.format_name($memprofile['username'], $memprofile['usergroup'], $memprofile['displaygroup']).'</a>';
			$status['avatar'] = $memprofile['avatar'];
			$status['username'] = $memprofile['username'];
			// If user is allowed to delete this status, form the delete button
			if (($usergroupsCache[$mybb->user['usergroup']]['mystatus_can_delete_own'] && $mybb->user['uid'] == $memprofile['uid']) || $usergroupsCache[$mybb->user['usergroup']]['mystatus_can_moderate'])
			{
				eval("\$mystatus_button['delete'] = \"".$templates->get('mystatus_button_delete')."\";");
			}
			else
			{
				$mystatus_button['delete'] = '';
			}
			require_once MYBB_ROOT."inc/class_parser.php";
			$parser = new postParser;
			// Set up our parser to output a nice version of the status to be added to the recent updates list
			$parserOptions	=	array
								(
									'allow_html'		=> 0,
									'allow_smilies'		=> 1,
									'allow_mycode'		=> 1,
									'nl2br'				=> 0,
									'filter_badwords'	=> 1,
									'me_username'		=> $status['username'],
									'shorten_urls'		=> 1
								);
			$status['status'] = $parser->parse_message($status['status'], $parserOptions);
			eval("\$mystatus_latest_statuses_row .= \"".$templates->get('mystatus_latest_statuses_row')."\";");
			// Prepare the $altbg variable for the next row
			if ($altbg == 'trow1')
			{
				$altbg = 'trow2';
			}
			else
			{
				$altbg = 'trow1';
			}
		}
		
		if ($db->num_rows($query) == 0)
		{
			eval("\$mystatus_latest_statuses_row = \"".$templates->get('mystatus_latest_statuses_row_no_statuses')."\";");
		}
		if ($altbg == 'trow1')
		{
			$altbg = 'trow2';
		}
		else
		{
			$altbg = 'trow1';
		}
		if ($mybb->user['uid'] == $memprofile['uid'])
		{
			eval("\$mystatus_update_form = \"".$templates->get('mystatus_update_form')."\";");
		}
		// Finally get the template
		eval("\$mystatus_latest_statuses = \"".$templates->get('mystatus_latest_statuses')."\";");
	}
}

// Process MyStatus Actions
$plugins->add_hook('misc_start', 'mystatus_process');
function mystatus_process()
{
	global $lang, $mybb, $db, $templates, $theme, $cache;
	$lang->load('mystatus');
	
	// Updating the actual status
	if ($mybb->input['action'] == 'mystatus_update' && $mybb->request_method == 'post')
	{
		if (!verify_post_check($mybb->input['my_post_key'], true))
		{
			// Was the request made via AJAX? If not, send a user friendly page
			if ($mybb->input['accessMethod'] == 'js')
			{
				header('HTTP/1.0 600');
				echo $lang->mystatus_error_updating;
			}
			else
			{
				error($lang->mystatus_error_updating);
			}
			die();
		}
		
		// Is the status long enough?
		if (intval($mybb->settings['mystatus_min_length']) != 0)
		{
			if (strlen(trim($mybb->input['statusText'])) < $mybb->settings['mystatus_min_length'])
			{
				// Was the request made via AJAX? If not, send a user friendly page
				if ($mybb->input['accessMethod'] == 'js')
				{
					header('HTTP/1.0 600');
					echo $lang->mystatus_error_status_too_short;
				}
				else
				{
					error($lang->mystatus_error_status_too_short);
				}
				die();
			}
		}
		
		// Or is it too long?
		if (intval($mybb->settings['mystatus_max_length']) != 0)
		{
			if (strlen(trim($mybb->input['statusText'])) > $mybb->settings['mystatus_max_length'])
			{
				// Was the request made via AJAX? If not, send a user friendly page
				if ($mybb->input['accessMethod'] == 'js')
				{
					header('HTTP/1.0 600');
					echo $lang->mystatus_error_status_too_long;
				}
				else
				{
					error($lang->mystatus_error_status_too_long);
				}
				die();
			}
		}
		// Prepare our array of information to insert
		$insertArray	=	array
							(
								'uid'		=>	intval($mybb->user['uid']),
								'status'	=>	$db->escape_string($mybb->input['statusText']),
								'dateline'	=>	time()
							);
							
		// Post new status to twitter if enabled by board admin and user
		if ($mybb->user['mystatus_twitter_posting_enabled'] && $mybb->settings['mystatus_post_to_twitter'])
		{
			require_once(MYBB_ROOT.'inc/plugins/mystatus/twitteroauth.php');
			$connection = new TwitterOAuth($mybb->settings['mystatus_twitter_consumer'], $mybb->settings['mystatus_twitter_consumer_secret'], $mybb->user['mystatus_twitter_oauth_token'], $mybb->user['mystatus_twitter_oauth_token_secret']);
			$response = $connection->post('statuses/update', array('status' => substr(htmlspecialchars_uni(stripslashes($insertArray['status'])), 0, 140)));
			$insertArray['tweetid'] = $db->escape_string($response->id_str);
		}
			
		if ($db->insert_query('statuses', $insertArray))
		{			
			// Was the request made via AJAX? If not, send a user friendly page
			if ($mybb->input['accessMethod'] == 'js')
			{
				require_once MYBB_ROOT."inc/class_parser.php";
				$parser = new postParser;
				// Set up our parser to output a nice version of the status to be added to the recent updates list
				$parserOptions	=	array
									(
										'allow_html'		=> 0,
										'allow_smilies'		=> 1,
										'allow_mycode'		=> 1,
										'nl2br'				=> 0,
										'filter_badwords'	=> 1,
										'me_username'		=> $mybb->user['username'],
										'shorten_urls'		=> 1
									);
				// Set up our status array with information about the user, date posted etc
				$status	=	array
							(
								'sid'				=>	intval($db->insert_id()),
								'username'			=>	$mybb->user['username'],
								'formattedusername'	=>	'<a href="'.get_profile_link($mybb->user['uid']).'">'.format_name($mybb->user['username'], $mybb->user['usergroup'], $mybb->user['displaygroup']).'</a>',
								'dateline'			=>	my_date($mybb->settings['dateformat'], time()).', '.my_date($mybb->settings['timeformat'], time()),
								'avatar'			=>	$mybb->user['avatar'],
								'status'			=>	$parser->parse_message($mybb->input['statusText'], $parserOptions)
							);
							
				$altbg = 'trow1';
				$usergroupsCache = $cache->read('usergroups');
				if ($usergroupsCache[$mybb->user['usergroup']]['mystatus_can_delete_own'] || $usergroupsCache[$mybb->user['usergroup']]['mystatus_can_moderate'])
				{
					eval("\$mystatus_button['delete'] = \"".$templates->get('mystatus_button_delete')."\";");
				}
				eval("\$mystatus_latest_statuses_row .= \"".$templates->get('mystatus_latest_statuses_row')."\";");
				echo $mystatus_latest_statuses_row;
			}
			else
			{
				redirect($_SERVER['HTTP_REFERER'], $lang->mystatus_status_updated_message, $lang->mystatus_status_updated);
			}
		}
		else // Status insert unsuccessful
		{
			// Was the request made via AJAX? If not, send a user friendly page
			if ($mybb->input['accessMethod'] == 'js')
			{
				echo $lang->mystatus_error_updating;
			}
			else
			{
				error($lang->mystatus_error_updating);
			}
		}
	}
	elseif ($mybb->input['action'] == 'mystatus_delete') // Deleting a status
	{
		// Make sure the sid is actually a valid number (must be greater than 0)
		if (intval($mybb->input['sid']) < 1)
		{
			// Was the request made via AJAX? If not, send a user friendly page
			if ($mybb->input['accessMethod'] == 'js')
			{
				header('HTTP/1.0 600');
				echo $lang->mystatus_error_deleting_invalid_status;
			}
			else
			{
				error($lang->mystatus_error_deleting_invalid_status);
			}
			die();
		}
		
		// Check if current user can actually delete this status
		$usergroupCache = $cache->read('usergroups');
		$status = $db->fetch_array($db->simple_select('statuses', 'tweetid, uid', 'sid = '.intval($mybb->input['sid'])));
		if (($usergroupCache[$mybb->user['usergroup']]['mystatus_can_delete_own'] && $mybb->user['uid'] == $status['uid']) || $usergroupCache[$mybb->user['usergroup']]['mystatus_can_moderate'])
		{
			if ($mybb->user['mystatus_twitter_posting_enabled'] && $mybb->settings['mystatus_post_to_twitter'])
			{
				require_once(MYBB_ROOT.'inc/plugins/mystatus/twitteroauth.php');
				$connection = new TwitterOAuth($mybb->settings['mystatus_twitter_consumer'], $mybb->settings['mystatus_twitter_consumer_secret'], $mybb->user['mystatus_twitter_oauth_token'], $mybb->user['mystatus_twitter_oauth_token_secret']);
				$connection->delete('statuses/destroy/'.intval($status['tweetid']));
			}
			
			// Do the actual deletion
			if ($db->delete_query('statuses', 'sid = '.intval($mybb->input['sid']), '1'))
			{
				// Was the request made via AJAX? If not, send a user friendly page
				if ($mybb->input['accessMethod'] == 'js')
				{
					echo $lang->mystatus_status_deleted_message;
				}
				else
				{
					redirect($_SERVER['HTTP_REFERER'], $lang->mystatus_status_deleted_message, $lang->mystatus_deleted_updated);
				}
			}
			else // Deletion failed for some reason
			{
				// Was the request made via AJAX? If not, send a user friendly page
				if ($mybb->input['accessMethod'] == 'js')
				{
					header('HTTP/1.0 600');
					echo $lang->mystatus_error_deleting;
				}
				else
				{
					error($lang->mystatus_error_deleting);
				}
			}
		}
		else // Not allowed to delete
		{
			if ($mybb->input['accessMethod'] == 'js')
			{
				echo $lang->mystatus_status_delete_nopermissions;
			}
			else
			{
				redirect($_SERVER['HTTP_REFERER'], $lang->mystatus_status_delete_nopermissions, $lang->mystatus_status_delete_nopermissions);
			}
		}
	}
}
?>