<?php
/*
 * Copyright (c) 2012, Brian McCloskey. All rights reserved.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Disallow direct access to this file for security reasons
if (!defined("IN_MYBB"))
{
	die('Direct access to this file is not allowed.');
}

// Define hooks
$plugins->add_hook('parse_message','spoiler_add');

// Plugin information
function spoiler_info()
{
	return array(
		'name'			=> 'هاك اخفاء نص',
		'description'	=> 'يمكنك من اضافة زر اخفاء لنص او جزء من الموضوع يظهر حين الضغط  علي الزر.',
		'website'		=> '',
		'author'		=> 'Brian McCloskey',
		'authorsite'	=> '',
		'version'		=> '1.0.0',
		'guid'			=> '9ab1c04e72fce4f749327a854a84cf61',
		'compatability'	=> '16*'
		);
}

// Plugin install
function spoiler_install()
{
	global $db;
	
	require_once(MYBB_ADMIN_DIR.'inc/functions_themes.php');
	
	// Default stylesheet added to Master Template for skinning the spoiler.
	$spoiler_stylesheet_template = @file_get_contents(MYBB_ROOT.
		'inc/plugins/spoiler/spoiler.css');
	$spoiler_stylesheet = array(
		'sid'			=> NULL,
		'name'			=> 'spoiler.css',
		'tid'			=> '1',
		'stylesheet'	=> $db->escape_string($spoiler_stylesheet_template),
		'cachefile'		=> 'spoiler.css',
		'lastmodified'	=> TIME_NOW
		);
	$db->insert_query('themestylesheets', $spoiler_stylesheet);
	cache_stylesheet(1, 'spoiler.css', $spoiler_stylesheet_template);
	
	rebuild_settings();
	update_theme_stylesheet_list("1");
}

// Plugin uninstall
function spoiler_uninstall()
{
	global $db;
	
	require_once(MYBB_ADMIN_DIR.'inc/functions_themes.php');
	
	$db->query('DELETE FROM '.TABLE_PREFIX.'themestylesheets WHERE name=\'spoiler.css\'');
	
	$query = $db->simple_select('themes', 'tid');
	
	while ($tid = $db->fetch_field($query, 'tid'))
	{
		$css_file = MYBB_ROOT."cache/themes/theme{$tid}/spoiler.css";
		if (file_exists($css_file))
			unlink($css_file);
	}
	
	update_theme_stylesheet_list("1");
}

// Plugin is_installed
function spoiler_is_installed()
{
	$css_file = MYBB_ROOT.'cache/themes/theme1/spoiler.css';
	
	if (file_exists($css_file))
		return true;
		
	return false;
}

// Plugin activate
function spoiler_activate()
{
}

// Plugin deactivate
function spoiler_deactivate()
{
}

// spoiler_add
function spoiler_add($message)
{
	$matches = array();
	$count = 0;
	
	$pattern = '#\[spoiler[=]?(?:&quot;|"|\')?([^\]].*?)?(?:&quote;|"|\')?\](.*?)\[/spoiler\]#si';

	$message = preg_replace_callback($pattern, "spoiler_callback", $message);

	return ($message);
}

function spoiler_callback($matches)
{
	if ($matches[1] == '')
		$title = 'Spoiler';
	else
		$title = $matches[1];

	$content = $matches[2];

	return "<div class=\"spoiler_outer\"><div><span class=\"spoiler_title\">" . $title . ":  </span><a onClick=\"if(this.parentNode.parentNode.getElementsByTagName('div')[1].getElementsByTagName('div')[0].style.display != '') { this.parentNode.parentNode.getElementsByTagName('div')[1].getElementsByTagName('div')[0].style.display = ''; this.innerHTML='احفاء'; } else { this.parentNode.parentNode.getElementsByTagName('div')[1].getElementsByTagName('div')[0].style.display = 'none'; this.innerHTML='اظهار'; }\" class=\"spoiler_button\">اظهار</a></div><div><div class=\"spoiler_content\" style=\"display: none;\">" . $content . "</div></div></div>";
}