<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

// Disallow direct access to this file for security reasons
if (!defined ("IN_MYBB"))
{
	die ("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

require_once MYBB_ROOT."inc/adminfunctions_templates.php";
require_once MYBB_ROOT."inc/plugins/d3mocracy/config.php";
require_once MYBB_ROOT."inc/plugins/d3mocracy/functions.php";
d3mocracyLoadClasses();
define('D3MOCRACY_VERSION', '1.0.3');
define('D3MOCRACY_INT_VERSION', '103');

$plugins->add_hook("global_start", "d3mocracy_init");
$plugins->add_hook("global_end", "d3mocracy_set_templates");
$plugins->add_hook("showthread_start", "d3mocracy_fetch_users");
$plugins->add_hook("postbit", "d3mocracy_postbit");
$plugins->add_hook("member_profile_end", "d3mocracy_expire");
$plugins->add_hook("usercp_avatar_start", "d3mocracy_halt_avatar_change");
$plugins->add_hook("usercp_do_avatar_start", "d3mocracy_halt_avatar_change");
$plugins->add_hook("usercp_menu_built", "d3mocracy_disable_avatar_change_link");
$plugins->add_hook("usercp_options_start", "d3mocracy_options");
$plugins->add_hook("usercp_do_options_start", "d3mocracy_update_options");
$plugins->add_hook("modcp_editprofile_end", "d3mocracy_remove_avatar_delete_checkbox");
$plugins->add_hook("admin_user_users_delete_commit", "d3mocracy_user_delete");
$plugins->add_hook("admin_config_settings_begin", "d3mocracy_load_lang");
$plugins->add_hook("admin_tools_recount_rebuild_output_list","d3mocracy_tools_recount_rebuild_list");
$plugins->add_hook("admin_tools_recount_rebuild_start", "d3mocracy_tools_do_recount_rebuild");

/**
 * Injects %%d3mocracy_header%% comment into template so it can be replaced on global_end
 */
function d3mocracy_init()
{
	global $templatelist, $lang, $mybb;
	$mybb->d3mocracyHeader = '';
	
	if(THIS_SCRIPT === 'showthread.php')
	{
		$lang->load('d3mocracy');
		$templatelist .= (substr($templatelist, -1) === ',' ? '' : ',') .
			'd3mocracy_header,d3mocracy_avatar_count,d3mocracy_empty_avatar';
		$mybb->d3mocracyHeader = '<!-- %%d3mocracy_header%% -->';
	}
	else if(THIS_SCRIPT === 'usercp.php')
	{
		$lang->load('d3mocracy');
		$templatelist .= (substr($templatelist, -1) === ',' ? '' : ',') .
			'd3mocracy_usercp_script';
		$mybb->d3mocracyHeader = '<!-- %%d3mocracy_header%% -->';
	}
}

/**
 * Replaces %%d3mocracy_header%% comment with the actual template
 */
function d3mocracy_set_templates()
{
	global $mybb, $db, $lang, $templates, $headerinclude;
	$d3mocracyHeader = '';
	
	if(THIS_SCRIPT === 'showthread.php')
	{
		$dbUsers = new D3mocracyUsersDB($db);
		$requesterD3Status = $dbUsers->fetchUserStatus($mybb->user['uid']);
		$requester = new D3mocracyRequester($requesterD3Status, $mybb);
		
		if(!$requester->canAct())
			$d3mocracyUserRole = 'none';
		else if($requester->status == 'off')
			$d3mocracyUserRole = 'exd3mocrat';
		else
			$d3mocracyUserRole = 'd3mocrat';
		
		$langEntries = array('d3mocracy_request_failed',
			'd3mocracy_delete_confirm', 'd3mocracy_actions_suspended',
			'd3mocracy_like_avatar', 'd3mocracy_dislike_avatar',
			'd3mocracy_remove_like', 'd3mocracy_remove_dislike');
		
		foreach($langEntries as $langEntry)
			$lang->$langEntry = addslashes($lang->$langEntry);
		
		$d3mocracyWindowBoxWrap = D3MOCRACY_WINDOW_BOX_WRAP;
		eval('$d3mocracyHeader = "'.$templates->get("d3mocracy_header").'";');
	}
	else if(THIS_SCRIPT === 'usercp.php')
	{
		$lang->d3mocracy_cannot_change_avatar = addslashes($lang->d3mocracy_cannot_change_avatar);
		eval('$d3mocracyHeader = "'.$templates->get("d3mocracy_usercp_script").'";');
	}
	$headerinclude = str_replace('<!-- %%d3mocracy_header%% -->', $d3mocracyHeader, $headerinclude);
}

/**
 * Fetches user parameters to be used later in postbit
 */
function d3mocracy_fetch_users()
{
	global $db, $tid, $templates, $mybb, $lang;
	$mybb->d3mocracyUsers = array();
	$dbUsers = new D3mocracyUsersDB($db);
	
	foreach($dbUsers->fetchUsersFromTid((int)$tid) as $user)
	{
		$user['avatarcount'] = (int)$user['avatarcount'];
		$mybb->d3mocracyUsers[$user['uid']] = $user;
	}
}

/**
 * Inserts some user parameters into post
 *
 * @param array $post Fetched post parameters
 */
function d3mocracy_postbit($post)
{
	global $db, $templates, $mybb, $lang;
	$user = &$mybb->d3mocracyUsers[$post['uid']];
	
	if($user['emptyavatar'] == '1')
	{
		eval('$post[\'d3mocracyemptyavatar\'] = "'.$templates->get("d3mocracy_empty_avatar").'";');
		$post['avatar_padding'] = "padding-right: 10px;";
	}
	else
		$post['d3mocracyemptyavatar'] = '';
	
	if($user['status'] !== 'off')
		eval('$post[\'avatarcount\'] = "'.$templates->get('d3mocracy_avatar_count').'";');
	else
		$post['avatarcount'] = '';
	
	$post['d3mocracystatus'] = $user['status'] === 'off' ? 'off' : 'on';
	eval('$post[\'user_details\'] = "'.$templates->get("postbit_author_user").'";');
	
	return $post;
}

/**
 * Deletes user's expired avatars
 */
function d3mocracy_expire()
{
	global $db, $uid;
	
	$dbAvatars = new D3mocracyAvatarsDB($db);
	$dbVotes = new D3mocracyVotesDB($db);
	$dbUsers = new D3mocracyUsersDB($db);
	$window = new D3mocracyWindow();
	$windowActions = new D3mocracyWindowActions($window);
	$owner = new D3mocracyOwner(array('uid' => $uid), $window);
	
	// Fetch and expire
	$window->pickAvatars($dbAvatars->fetchOwnerAvatarsFromOwnerID($uid));
	$activeAvatar = $windowActions->handleExpiredAvatars(
		$owner, $dbAvatars, $dbVotes, $dbUsers, $updated, true);
}

/**
 * Disables avatar change in User CP if the user is a D3mocrat
 */
function d3mocracy_halt_avatar_change()
{
	global $db, $templates, $mybb, $lang;
	$dbUsers = new D3mocracyUsersDB($db);
	$status = $dbUsers->fetchUserStatus($mybb->user['uid']);
	
	if($status === 'on')
		error($lang->d3mocracy_cannot_change_avatar);
}

/**
 * Sets new attributes to Change Avatar link in the user CP menu to make sure it gets disabled
 */
function d3mocracy_disable_avatar_change_link()
{
	global $usercpnav, $db, $templates, $mybb, $lang;
	$dbUsers = new D3mocracyUsersDB($db);
	$status = $dbUsers->fetchUserStatus($mybb->user['uid']);
	
	if($status === 'on')
	{
		$usercpnav = str_replace('class="usercp_nav_item usercp_nav_avatar"',
			'class="usercp_nav_item usercp_nav_avatar d3mocracy_disabled" style="text-decoration: line-through;"',
			$usercpnav);
	}
}

/**
 * Deletes user avatars and votes
 */
function d3mocracy_user_delete()
{
	global $db, $user, $templates, $mybb, $lang;
	
	$dbAvatars = new D3mocracyAvatarsDB($db);
	$dbUsers = new D3mocracyUsersDB($db);
	
	$dbAvatars->deleteAvatarsVotes($dbAvatars->fetchAvatarsForDeletion($user['uid']));
	$dbUsers->deleteUser($user['uid']);
}

/**
 * Sets up options form
 */
function d3mocracy_options()
{
	global $db, $templates, $mybb, $lang;
	$mybb->d3mocracyOptions = array('disablecheck' => '');
	
	$dbUsers = new D3mocracyUsersDB($db);
	if($dbUsers->fetchUserStatus($mybb->user['uid']) === 'off')
		$mybb->d3mocracyOptions['disablecheck'] = 'checked="checked"';
}

/**
 * Sanitizes options and updates them, disables/enables D3mocracy
 */
function d3mocracy_update_options()
{
	global $db, $templates, $mybb, $lang;
	
	$status = $mybb->input['d3mocracydisablesubmissions'] == '1' ? 'off' : 'on';
	$requester = new D3mocracyRequester($status, $mybb);
	$dbUsers = new D3mocracyUsersDB($db);
	$previousStatus = $dbUsers->fetchUserStatus($mybb->user['uid']);
	$dbUsers->updateUserStatus($requester->getID(), $status);
	
	// D3mocracy enabled, expire and reactivate
	if($status == 'on' && $previousStatus == 'off')
	{
		// Create necessary models, actions and DBs
		$dbAvatars = new D3mocracyAvatarsDB($db);
		$dbVotes = new D3mocracyVotesDB($db);
		$window = new D3mocracyWindow();
		$windowActions = new D3mocracyWindowActions($window);
		$owner = D3mocracyOwner::createFromRequester($requester, $window);
		
		// Fetch and expire
		$window->pickAvatars($dbAvatars->fetchAvatars($requester, $requester->getID(), null));
		$activeAvatar = $windowActions->handleExpiredAvatars(
			$owner, $dbAvatars, $dbVotes, $dbUsers, $updated);
		
		// If active avatar didn't get updated, update it
		if(!$updated && $activeAvatar instanceof D3mocracyAvatar)
			$dbUsers->setProfileAvatar($requester->getID(), $activeAvatar);
		else if(!$updated)
			$dbUsers->setProfileAvatar($requester->getID());
		
		// Delete uploaded file of the previously active avatar
		if($mybb->user['avatartype'] == 'upload')
			@unlink(MYBB_ROOT.'/'.d3mocracyGetAvatarFileName($mybb->user['avatar'], false));
	}
	// D3mocracy disabled, set empty profile avatar
	else if($status == 'off' && $previousStatus == 'on')
		$dbUsers->setProfileAvatar($requester->getID());
}

/**
 * Removes avatar delete checkbox from the Mod CP profile editor
 */
function d3mocracy_remove_avatar_delete_checkbox()
{
	global $templates;
	
	$templates->cache['modcp_editprofile'] = preg_replace('@'.
		'<tr[\w\s\-\'"=/]*>\s*<td[\w\s\-\'"=/]*>\s*<span[\w\s\-\'"=/]*>\s*<label[\w\s\-\'"=/]*>\s*'.
		'<input[\w\s\-\'"=/]*>\s*\{\$lang\->remove_avatar\}\s*</label>\s*</span>\s*</td>\s*</tr>'.
		'@', '', $templates->cache['modcp_editprofile']);
}

/**
 * Inserts d3mocracy recount tool link to the tools menu
 */
function d3mocracy_tools_recount_rebuild_list()
{
	global $lang, $form, $form_container;
	// $lang was loaded with d3mocracy values in d3mocracy_tools_do_recount_rebuild()
	
	$form_container->output_cell("<label>{$lang->d3mocracy_recount_votes_title}</label><div class=\"description\">{$lang->d3mocracy_recount_votes_desc}</div>");
	$form_container->output_cell($form->generate_text_box("d3mocracyavatarsperpage", 500, array('style' => 'width: 150px;')));
	$form_container->output_cell($form->generate_submit_button($lang->go, array("name" => "do_d3mocracyrecountvotes")));
	$form_container->construct_row();
	
	$form_container->output_cell("<label>{$lang->d3mocracy_recount_avatars_title}</label><div class=\"description\">{$lang->d3mocracy_recount_avatars_desc}</div>");
	$form_container->output_cell($form->generate_text_box("d3mocracyusersperpage", 500, array('style' => 'width: 150px;')));
	$form_container->output_cell($form->generate_submit_button($lang->go, array("name" => "do_d3mocracyrecountavatars")));
	$form_container->construct_row();
}

/**
 * Recounts and rebuilds D3mocracy stuff
 */
function d3mocracy_tools_do_recount_rebuild()
{
	global $mybb, $lang, $db;
	$lang->load('d3mocracyadmin');
	
	if(!isset($mybb->input['page']) || (int)$mybb->input['page'] < 1)
		$mybb->input['page'] = 1;
	
	if($mybb->request_method == "post")
	{
		// Recount votes
		if(isset($mybb->input['do_d3mocracyrecountvotes']))
		{
			if(!isset($mybb->input['d3mocracyavatarsperpage']))
				$mybb->input['d3mocracyavatarsperpage'] = 500;
			
			$dbAvatars = new D3mocracyAvatarsDB($db);
			$dbVotes = new D3mocracyVotesDB($db);
			
			$page = (int)$mybb->input['page'];
			$per  = (int)$mybb->input['d3mocracyavatarsperpage'];
			$num  = $dbAvatars->fetchNumAvatars();
			$pos  = $per * ($page - 1);
			$end  = $per + $pos;
			
			$dbVotes->recountVotes($pos, $per);
			check_proceed($num, $end, ++$page, $per,
				"d3mocracyavatarsperpage", "do_d3mocracyrecountvotes",
				$lang->d3mocracy_recount_votes_success);
		}
		
		// Recount avatars
		else if(isset($mybb->input['do_d3mocracyrecountavatars']))
		{
			if(!isset($mybb->input['d3mocracyusersperpage']))
				$mybb->input['d3mocracyusersperpage'] = 500;
			
			$dbUsers = new D3mocracyUsersDB($db);
			$dbAvatars = new D3mocracyAvatarsDB($db);
			
			$page = (int)$mybb->input['page'];
			$per  = (int)$mybb->input['d3mocracyusersperpage'];
			$num  = $dbUsers->fetchNumUsers();
			$pos  = $per * ($page - 1);
			$end  = $per + $pos;
			
			$dbAvatars->recountAvatars($pos, $per);
			check_proceed($num, $end, ++$page, $per,
				"d3mocracyusersperpage", "do_d3mocracyrecountavatars",
				$lang->d3mocracy_recount_avatars_success);
		}
	}
}

/**
 * Loads language file
 */
function d3mocracy_load_lang()
{
	global $lang;
	$lang->load('d3mocracyadmin');
}

/**
 * Returns plugin parameters
 *
 * @param array Array with plugin parameters
 */
function d3mocracy_info()
{
	global $mybb;
	$dir = d3mocracyGetUploadDirName();
	$msg = d3mocracyDirIsWritable() ? '' : '<br /><span style="color:#900;">Warning: '.
		$dir.' isn\'t writable! D3mocracy will NOT be installed!</span>';
	
	return array
	(
		"name"          => "هاك الصورة الرمزية المتقدمه",
		"description"   => "يمكن الاعضاء من مشاركه الصور الرمزية وارسالها لعبضهم البعض".$msg,
		"author"        => "Saša T.",
		"version"       => D3MOCRACY_VERSION,
		"compatibility"	=> "16*",
		"guid"          => "01f3e3279a4b130da836c60708a325a4",
	);
}

/**
 * Activates D3mocracy
 */
function d3mocracy_activate()
{
	if(d3mocracyDirIsWritable())
	{
		d3mocracyUninstallTemplates();
		d3mocracyInstallTemplates();
		rebuild_settings();
	}
}

/**
 * Deactivates D3mocracy
 */
function d3mocracy_deactivate()
{
	d3mocracyUninstallTemplates();
}

/**
 * Installs D3mocracy
 */
function d3mocracy_install()
{
	if(d3mocracyDirIsWritable())
	{
		d3mocracyInstallDB();
		d3mocracyInsertSettings();
	}
}

/**
 * Uninstalls D3mocracy
 */
function d3mocracy_uninstall()
{
	d3mocracyUninstallDB();
	d3mocracyRemoveSettings();
	d3mocracyDeleteFiles();
	rebuild_settings();
}

/**
 * Returns whether D3mocracy is installed
 *
 * @return bool True if it's installed, false if it's not
 */
function d3mocracy_is_installed()
{
	global $db;
	
	$gCount = (int)$db->fetch_field($db->query('SELECT COUNT(*) AS `count`
		FROM `'.TABLE_PREFIX.'settinggroups`
		WHERE `name` = "d3mocracy"'), 'count');
	
	$sCount = (int)$db->fetch_field($db->query('SELECT COUNT(*) AS `count`
		FROM `'.TABLE_PREFIX.'settings`
		WHERE `name` IN ("d3inactivityts", "d3activityts", "d3boxwrap", "d3maxavatars")'), 'count');
	
	return
		$gCount === 1 &&
		$sCount  >= 4 &&
		$db->table_exists('d3mocracy_avatars') &&
		$db->table_exists('d3mocracy_votes') &&
		$db->table_exists('d3mocracy_users');
}
