<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

/**
 * Avatar actions class
 */
class D3mocracyAvatarActions
{
	/**
	 * Avatar Model instance
	 *
	 * @var D3mocracyAvatar
	 */
	public $avatar;
	
	/**
	 * Constructor; Sets parameters
	 *
	 * @param D3mocracyAvatar $avatar Avatar Model instance
	 */
	public function __construct(D3mocracyAvatar $avatar)
	{
		$this->avatar = $avatar;
	}
	
	/**
	 * Moves file from MyBB avatar upload dir to D3mocracy dir and updates it in MyBB users
	 *
	 * @param MyBB $mybb MyBB object
	 * @param D3mocracyUsersDB $dbUsers Users DB object
	 */
	public function moveAvatar(MyBB $mybb, D3mocracyUsersDB $dbUsers)
	{
		if($this->avatar->type == 'upload' && strpos($this->avatar->url, $mybb->settings['avataruploadpath']) === 0)
		{
			// Rename file
			$oldFilePath = d3mocracyGetAvatarFileName($this->avatar->url, false);
			$newFilePath = d3mocracyGetUploadDirName().'/'.d3mocracyGetAvatarFileName($this->avatar->url);
			if(@rename(MYBB_ROOT.'/'.$oldFilePath, MYBB_ROOT.'/'.$newFilePath))
			{
				// Update URL locally and in database
				$this->avatar->url = $newFilePath.'?dateline='.d3mocracyGetTimeFromAvatarUrl($this->avatar->url);
				$dbUsers->updateProfileAvatarUrl($this->avatar->ownerid, $this->avatar->url);
			}
		}
	}
}