<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

/**
 * AvatarNew box View Component
 */
class D3mocracyAvatarNewView
{
	/**
	 * Instance of D3mocracyRequester Model
	 *
	 * @var D3mocracyRequester
	 */
	private $requester;
	
	/**
	 * Instance of D3mocracyOwner Model
	 *
	 * @var D3mocracyOwner
	 */
	private $owner;
	
	/**
	 * Constructor; Sets Requester Model instance
	 *
	 * @param D3mocracyRequester $requester Requester Model
	 */
	public function __construct(D3mocracyRequester $requester, D3mocracyOwner $owner)
	{
		$this->requester = $requester;
		$this->owner = $owner;
	}
	
	/**
	 * Returns whether AvatarNew box is visible
	 *
	 * @return bool True if it's visible, false if it isn't
	 */
	public function isVisible()
	{
		return $this->requester->canSubmitAvatar($this->owner);
	}
	
	/**
	 * Returns AvatarNew box's style which controls whether it's actually displayed
	 *
	 * @return string AvatarNew box's style HTML attribute or empty string
	 */
	public function getStyleHidden()
	{
		return !$this->isVisible() ? ' style="display:none;"' : '';
	}
	
	/**
	 * Renders AvatarNew box's template and returns output
	 *
	 * @param templates $templates Instance of templates, MyBB templating object
	 * @param D3mocracyWindowView $windowView Instance of WindowView object
	 * @return string Rendered AvatarNew box's HTML
	 */
	public function render(templates $templates, D3mocracyWindowView $windowView, MyLanguage $lang)
	{
		// For easy template access
		$avatarNewView = $this;
		
		// Get output
		eval('$avatarBox = "'.$templates->get("d3mocracy_avatar_box_new").'";');
		
		// Return output
		return $avatarBox;
	}
}