<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

/**
 * Vote Diff data object
 */
class D3mocracyAvatarVoteDiff extends D3mocracyModel
{
	/**
	 * Avatar ID
	 *
	 * @var int
	 */
	public $avatarid;
	
	/**
	 * Mode (added/updated/removed)
	 *
	 * @var string
	 */
	public $mode;
	
	/**
	 * Likes to append to vote cache
	 *
	 * @var int
	 */
	public $pluslikes;
	
	/**
	 * Dislikes to append to vote cache
	 *
	 * @var int
	 */
	public $plusdislikes;
	
	/**
	 * Returns this model's parameter names
	 *
	 * @return array Array with parameter names as keys and types as values
	 */
	public function getParamNames()
	{
		return array
		(
			'avatarid' => 'int',
			'mode' => 'string',
			'pluslikes' => 'int',
			'plusdislikes' => 'int',
		);
	}
}