<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

/**
 * Base Model
 */
abstract class D3mocracyModel
{
	/**
	 * Constructor; Sets parameters as properties
	 *
	 * @param array $params Parameters to set
	 */
	public function __construct(array $params)
	{
		$paramNames = $this->getParamNames();
		foreach($params as $currentName => $currentParam)
		{
			if(isset($paramNames[$currentName]))
			{
				switch($paramNames[$currentName])
				{
					case 'int':
						$this->$currentName = (int)$currentParam;
						break;
					
					case 'float':
						$this->$currentName = (float)$currentParam;
						break;
					
					case 'string':
						$this->$currentName = (string)$currentParam;
						break;
					
					case 'bool':
						$this->$currentName = (bool)$currentParam;
						break;
					
					case 'mixed':
						$this->$currentName = $currentParam;
						break;
				}
			}
		}
	}
}