<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

/**
 * Output printer convenience class
 */
class D3mocracyOutputPrinter
{
	/**
	 * MyLanguage object
	 *
	 * @var MyLanguage
	 */
	private $lang;
	
	/**
	 * templates object
	 *
	 * @var templates
	 */
	private $templates;
	
	/**
	 * Charset variable used by templates
	 *
	 * @var string
	 */
	private $charset;
	
	/**
	 * Stylesheets variable used by templates
	 *
	 * @var string
	 */
	private $stylesheets;
	
	/**
	 * Constructor; Sets dependencies
	 *
	 * @param MyLanguage $lang MyBB language class instance
	 * @param templates $templates MyBB templates class instance
	 * @param string $charset Charset string, used by headerinclude template
	 * @param string $stylesheets Stylesheets string, used by headerinclude template
	 */
	public function __construct(MyLanguage $lang, templates $templates, $charset, $stylesheets)
	{
		$this->lang = $lang;
		$this->templates = $templates;
		$this->charset = $charset;
		$this->stylesheets = $stylesheets;
	}
	
	/**
	 * Outputs JSON and exits
	 *
	 * @param array $parameters Parameters to convert to JSON
	 */
	public function json($parameters)
	{
		header("Content-type: application/json");
		die (json_encode($parameters));
	}
	
	/**
	 * Outputs error in JSON form and exits
	 *
	 * @param string $message Error message
	 * @param string $id Error identification code
	 */
	public function jsonError($message, $id = '0')
	{
		header("Content-type: application/json");
		die (json_encode(array('error' => array('message' => $message, 'id' => $id))));
	}
	
	/**
	 * Outputs HTML and exits
	 *
	 * @param string $content HTML to output
	 */
	public function html($content)
	{
		header("Content-type: text/html");
		die($content);
	}
	
	/**
	 * Outputs error in HTML form and exits
	 *
	 * @param string $title Error title
	 * @param string $message Error message
	 */
	public function htmlError($title, $message)
	{
		// Variables used by templates
		$lang = $this->lang;
		$templates = $this->templates;
		$charset = $this->charset;
		$stylesheets = $this->stylesheets;
		$body = inline_error($message, $title);
		
		// Fetch template and exit
		eval('output_page("'.$templates->get("d3mocracy_page").'");');
		exit;
	}
}