<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

/**
 * Avatar submission page View Component
 */
class D3mocracySubmitFormView
{
	/**
	 * Constructor; Sets Owner Model and language object
	 *
	 * @param D3mocracyOwner $owner Owner Model instance
	 * @param MyLanguage $lang MyBB language object
	 */
	public function __construct
	(
		D3mocracyOwner $owner,
		MyLanguage $lang
	){
		$this->owner = $owner;
		$this->lang = $lang;
	}
	
	/**
	 * Returns page title
	 */
	public function getTitle()
	{
		return htmlspecialchars_uni($this->lang->d3mocracy_submit_avatar_for.' '.$this->owner->username);
	}
	
	/**
	 * Renders avatar submission page
	 *
	 * @param templates $templates MyBB templates object
	 * @param MyBB $mybb MyBB object
	 * @param array $theme MyBB theme parameters
	 * @param string $charset Charset string used by templates
	 * @param string $stylesheets Stylesheet string used by templates
	 * @param string $avatarError String containing avatar submission error message
	 */
	public function render(templates $templates, MyBB $mybb, $theme, $charset, $stylesheets, $avatarError)
	{
		$title = $this->getTitle();
		$owner = $this->owner;
		$lang = $this->lang;
		
		if(!empty($avatarError))
			$avatarError = inline_error($avatarError);
		$autoResize = mybbUploadFormMessages();
		
		eval('$body = "'.$templates->get('d3mocracy_avatar_add').'";');
		eval('$page = "'.$templates->get("d3mocracy_page").'";');
		return $page;
	}
}