<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

/**
 * Submitted page View Component
 */
class D3mocracySubmittedView extends D3mocracySubmitFormView
{
	/**
	 * Renders submitted page with opener-accessing javascript
	 *
	 * @param D3mocracyAvatarView $avatarView Avatar View Component
	 * @param D3mocracyWindowView $windowView Window View Component
	 * @param array $avatarsJson Json date parameters to update
	 * @param templates $templates MyBB templates object
	 * @param MyBB $mybb MyBB object
	 * @param string $charset Charset string used by templates
	 * @param string $stylesheets Stylesheet string used by templates
	 */
	public function render
	(
		D3mocracyAvatarView $avatarView,
		D3mocracyWindowView $windowView,
		array $avatarsJson,
		templates $templates,
		MyBB $mybb,
		$charset,
		$stylesheets
	){
		$title = $this->getTitle();
		$owner = $this->owner;
		$lang = $this->lang;
		$avatarsJson = json_encode($avatarsJson);
		
		$avatarBox = $avatarView->render($templates, $windowView);
		eval('$body  = "'.$templates->get("d3mocracy_avatar_box_hidden_container").'";');
		eval('$body .= "'.$templates->get("d3mocracy_avatar_add_script").'";');
		eval('$page  = "'.$templates->get("d3mocracy_page").'";');
		return $page;
	}
}