<?php
/**
 * This file is part of D3mocracy.
 * 
 * D3mocracy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * at your option) any later version.

 * D3mocracy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with D3mocracy.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Saša T. <sasa@mindframes.org>
 */

// Disallow direct access to this file for security reasons
if (!defined ("IN_MYBB"))
{
	die ("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

global $mybb;

// Custom settings
define('D3MOCRACY_WINDOW_BOX_WRAP', (int)$mybb->settings['d3boxwrap']);
define('D3MOCRACY_MAX_AVATARS_PER_USER', (int)$mybb->settings['d3maxavatars']);
define('D3MOCRACY_ACTIVITY_TIME_SPAN', (int)$mybb->settings['d3activityts'] * 86400);
define('D3MOCRACY_INACTIVITY_TIME_SPAN', (int)$mybb->settings['d3inactivityts'] * 86400);

// Internal settings
define('D3MOCRACY_BOX_WIDTH_PADDING', 12);
define('D3MOCRACY_DATE_FORMAT', $mybb->settings['dateformat']);
define('D3MOCRACY_TIME_FORMAT', $mybb->settings['timeformat']);