<?php
/*
IconColumn V1.0
(c) 2012 by Salvatore
Website: http://salvatorelab.es
*/

$plugins->add_hook("admin_config_menu", "IconColumn_admin_nav");
$plugins->add_hook("admin_config_action_handler", "IconColumn_action_handler");
$plugins->add_hook("admin_load", "IconColumn_admin");
$plugins->add_hook("index_start", "IconColumn_index");

function IconColumn_info()
{
	return array(
		"name"		=> "IconColumn",
		"description"	=> "Right Column for Icons",
		"website"		=> "http://foro.universojuegos.es",
		"author"		=> "Salvatore",
		"authorsite"	=> "mailto:salvatore@universojuegos.es",
		"version"		=> "1.0",
		"guid"			=> "48fdc765a6cab9a0fe6c9e757d6afc16"
	);
}

function IconColumn_install()
{
    global $db;
    require_once(MYBB_ROOT."admincp/inc/functions_themes.php");

    // Add stylesheet to the master template so it becomes inherited.
    $stylesheet = "#icon_column { position: fixed; top: 160px; right: 0px; overflow: hidden; width: 100px; padding: 8px 0 8px 8px; }
#icon_column ul {margin:0;padding:0;}
#icon_column li { margin-left:50%; margin-bottom:20px; list-style:none; }
#icon_column li a { display:block; background-color:transparent; border-radius:8px 0 0 8px; }
#icon_column li:hover { margin-left:0; }";
    $IconColumn_stylesheet = array(
        'sid' => NULL,
        'name' => 'IconColumn.css',
        'tid' => '1',
        'stylesheet' => $db->escape_string($stylesheet),
        'cachefile' => 'IconColumn.css',
        'lastmodified' => TIME_NOW,
    );
    $db->insert_query('themestylesheets', $IconColumn_stylesheet);
    cache_stylesheet(1, "IconColumn.css", $stylesheet);
    update_theme_stylesheet_list("1");
	
	$db->query("CREATE TABLE IF NOT EXISTS `".TABLE_PREFIX."icon_column` (
        `id` int(11) NOT NULL auto_increment,
        `icon` varchar(100) NOT NULL default 'default.png',
        `link` varchar(250) NOT NULL,
        `title` varchar(60) NOT NULL,
		`disporder` int(11) NOT NULL default '0',
        PRIMARY KEY  (`id`)
        )ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=0;");
	
	require "../inc/adminfunctions_templates.php";	
	find_replace_templatesets("index", '#'.preg_quote('</body>').'#', '<div id="icon_column"><ul>{$icon_column}</ul></div></body>');
}

function IconColumn_is_installed()
{
	global $db;
	if($db->table_exists("icon_column"))
	{
		return true;
	}
	return false;
}

function IconColumn_uninstall()
{
    global $db;
    require_once(MYBB_ROOT."admincp/inc/functions_themes.php");

    // Remove myplugin.css from the theme cache directories if it exists
    $query = $db->simple_select("themes", "tid");
    while($tid = $db->fetch_field($query, "tid"))
    {
        $css_file = MYBB_ROOT."cache/themes/theme{$tid}/IconColumn.css";
        if(file_exists($css_file))
            unlink($css_file);
    }

    update_theme_stylesheet_list("1");
	
	$db->query("DROP TABLE IF EXISTS `".TABLE_PREFIX."icon_column`");
	
	require "../inc/adminfunctions_templates.php";	
	find_replace_templatesets("index", '#'.preg_quote('<div id="icon_column"><ul>{$icon_column}</ul></div>').'#', '',0);
} 

function IconColumn_activate()
{
	global $mybb, $db;
	
	//we make the new group in a array
	$ic_group = array(
        'gid'    => 'NULL',
        'name'  => 'icon_column',
        'title'      => 'IconColumn Plugin',
        'description'    => 'Settings For IconColumn Plugin',
        'disporder'    => "1",
        'isdefault'  => 'no',
    );
	//insert into DB
	$db->insert_query('settinggroups', $ic_group);
	$gid = $db->insert_id();

	//Now lets make a new setting
	$ic_setting = array(
        'sid'            => 'NULL',
        'name'        => 'enabled_icon_column',
        'title'            => 'Do you want IconColumn Plugin Enabled',
        'description'    => 'If Yes People Can Use it, If No People Cannot Use it.',
        'optionscode'    => 'yesno',
        'value'        => '1',
        'disporder'        => 1,
        'gid'            => intval($gid),
    ); 
	//a la DB
	$db->insert_query('settings', $ic_setting);
	rebuild_settings();
}

function IconColumn_deactivate()
{
	global $mybb, $db;
	
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN ('enabled_icon_column')");
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='icon_column'");
	rebuild_settings();
}

function IconColumn_action_handler(&$action)
{
	$action['IconColumn'] = array('active' => 'IconColumn', 'file' => '');
}

function IconColumn_admin_nav($sub_menu)
{
	global $lang;
	$lang->load("IconColumn");
	end($sub_menu);
	//$key = (key($sub_menu))+10;
	$sub_menu[] = array('id' => $lang->ic_url, 'title' => $lang->ic_name, 'link' => "index.php?module=config-".$lang->ic_url);
	return $sub_menu;
}

function IconColumn_admin()
{
	global $mybb, $db, $page, $lang, $cache;

	if($page->active_action != "IconColumn")
	{
		return;
	}
	$lang->load("IconColumn");
	$icon_dir = "images/IconColumn";
	$img = "<img src=\"../".$icon_dir."/";
	$img_delete = "<img src=styles/sharepoint/images/icons/delete.gif> ";
	$img_edit = "<img src=styles/sharepoint/images/icons/success.gif> ";
	$page->add_breadcrumb_item($lang->ic_name);
	$page->output_header($lang->ic_name);

	if($mybb->input['action'] == "new") {
		$form = new Form("index.php?module=config-".$lang->ic_url."&amp;action=save", "post", "save",1);
		$form_container = new FormContainer($lang->ic_new);
		$form_container->output_row($lang->ic_icon, $lang->ic_icon_des, $form->generate_file_upload_box("upload_icon", array('style' => 'width: 230px;')), 'file');
		$form_container->output_row($lang->ic_link, $lang->ic_link_des, '<input type="text" name="link" id="link" value="http://" />', 'link');
		$form_container->output_row($lang->ic_link_title, $lang->ic_link_title_des, '<input type="text" name="title" id="title" value="Title" />', 'title');
		$form_container->output_row($lang->ic_order, $lang->ic_order_des, '<input type="text" name="disporder" id="disporder" value="1" />', 'disporder');
		$form_container->end();

		$buttons[] = $form->generate_submit_button($lang->ic_submit);
		$form->output_submit_wrapper($buttons);
		$form->end();
		$page->output_footer();
	}
	if($mybb->input['action'] == "edit") {
		
		$query = $db->query("
			SELECT * FROM ".TABLE_PREFIX."icon_column
			WHERE id='".$mybb->input['icid']."' 
			ORDER BY `disporder` ASC
		");
		while($row = $db->fetch_array($query)) {
			$form = new Form("index.php?module=config-".$lang->ic_url."&amp;action=save", "post", "save",1);
			echo $form->generate_hidden_field("icid", $mybb->input['icid']);
			$form_container = new FormContainer($lang->ic_edit);

			$form_container->output_row($lang->ic_icon, $lang->ic_icon_des, $form->generate_file_upload_box("upload_icon", array('style' => 'width: 230px;')), 'file');
			$form_container->output_row($lang->ic_used_icon, $lang->ic_used_des, "{$img}".$row['icon']."\" >", 'icon');
			$form_container->output_row($lang->ic_link, $lang->ic_link_des, '<input type="text" name="link" value="'.$row['link'].'" />', 'link');
			$form_container->output_row($lang->ic_link_title, $lang->ic_link_title_des, '<input type="text" name="title" value="'.$row['title'].'" />', 'title');
			$form_container->output_row($lang->ic_order, $lang->ic_order_des, '<input type="text" name="disporder" value="'.$row['disporder'].'" />', 'disporder');
			$form_container->end();

			$buttons[] = $form->generate_submit_button($lang->ic_submit);
			$form->output_submit_wrapper($buttons);
			$form->end();
			$page->output_footer();
			break;
		}
	}
	if($mybb->input['action'] == "save")
	{
		if (empty($_FILES['upload_icon']['name']) && intval($mybb->input['icid']) != 0) {
			//file not edited, this is not a problem
			//just update link and order
			$update = array(
				"link" => $db->escape_string($mybb->input['link']),
				"title" => $db->escape_string($mybb->input['title']),
				"disporder" => intval($mybb->input['disporder']),
			);
			$db->update_query("icon_column", $update, "id='".$db->escape_string($mybb->input['icid'])."'");
			
			flash_message($lang->ic_ok, 'success');
			admin_redirect("index.php?module=config-".$lang->ic_url);
		} else {
			$dirpath = MYBB_ROOT."images/".$lang->ic_url;
			$file_type = $_FILES['upload_icon']['type'];
			switch(strtolower($file_type)) {
				case "image/gif":
				case "image/jpeg":
				case "image/x-jpg":
				case "image/x-jpeg":
				case "image/pjpeg":
				case "image/jpg":
				case "image/png":
				case "image/x-png":
					$typeicon =  1;
					break;
				default:
					$typeicon = 0;
			}

			if($typeicon == 0) {
				flash_message($lang->ic_no_file, 'error');
				if (intval($mybb->input['icid']) != 0) {
					admin_redirect("index.php?module=config-".$lang->ic_url."&amp;action=edit&amp;icid=".intval($mybb->input['icid']));
				} else {
					admin_redirect("index.php?module=config-".$lang->ic_url."&amp;action=new");
				}
			}

			if ($_FILES['upload_icon']['error'] == '0') {
				$icono_image = $_FILES['upload_icon']['tmp_name'];
				$newfile = $dirpath . "/" . $_FILES['upload_icon']['name'];
				if (!copy($icono_image, $newfile)) {
					flash_message($lang->ic_no_file_again, 'error');
					if (intval($mybb->input['icid']) != 0) {
						admin_redirect("index.php?module=config-".$lang->ic_url."&amp;action=edit&amp;icid=".intval($mybb->input['icid']));
					} else {
						admin_redirect("index.php?module=config-".$lang->ic_url."&amp;action=new");
					}	
				}
				
				//is it edit or add new?
				if (intval($mybb->input['icid']) != 0) {
					$update = array( 
						"icon" => $_FILES['upload_icon']['name'],
						"link" => $db->escape_string($mybb->input['link']),
						"title" => $db->escape_string($mybb->input['title']),
						"disporder" => intval($mybb->input['disporder']),
					);
					$db->update_query("icon_column", $update, "id='".$db->escape_string($mybb->input['icid'])."'");
				} else {
					$entry = array(
						"link" => $db->escape_string($mybb->input['link']),
						"title" => $db->escape_string($mybb->input['title']),
						"icon" => $_FILES['upload_icon']['name'],
						"disporder" => intval($mybb->input['disporder']),
					);
					$db->insert_query("icon_column", $entry);
				}

				flash_message($lang->ic_file_success, 'success');
				admin_redirect("index.php?module=config-".$lang->ic_url."");

			} else {
				flash_message($lang->ic_no_file_again, 'error');
				if (intval($mybb->input['icid']) != 0) {
					admin_redirect("index.php?module=config-".$lang->ic_url."&amp;action=edit&amp;icid=".intval($mybb->input['icid']));
				} else {
					admin_redirect("index.php?module=config-".$lang->ic_url."&amp;action=new");
				}
			}
		}

	}
	if($mybb->input['action'] == "delete") {
		$query = $db->simple_select("icon_column", "*", "id='".intval($mybb->input['icid'])."'");
		$row = $db->fetch_array($query);

		if(!$row['id'])
		{
			flash_message("Error", 'error');
			admin_redirect("index.php?module=config-".$lang->ic_url);
		}

		// User clicked no
		if($mybb->input['no'])
		{
			admin_redirect("index.php?module=config-".$lang->ic_url);
		}

		if($mybb->request_method == "post")
		{					
			$db->query("DELETE FROM ".TABLE_PREFIX."icon_column where id='".$row['id']."'");
			flash_message($lang->ic_deleted, 'success');
			admin_redirect("index.php?module=config-".$lang->ic_url);
		}
		else
		{
			$page->output_confirm_action("index.php?module=config-".$lang->ic_url);
		}
	}
	
	//add button
	echo '<div class="nav_tabs"><ul><li class="first"><a href="index.php?module=config-'.$lang->ic_url.'&amp;action=new">'.$lang->ic_new.'</a></li></ul></div>';
	
	$table = new Table;
	$table->construct_header($lang->ic_id, array("width" => "5%"));
	$table->construct_header($lang->ic_title, array("class" => "align_center", "width" => "15%"));
	$table->construct_header($lang->ic_link, array("class" => "align_center", "width" => "15%"));
	$table->construct_header($lang->ic_icon, array("class" => "align_center", "width" => "20%"));
	$table->construct_header($lang->ic_order, array("class" => "align_center", "width" => "5%"));
	$table->construct_header($lang->ic_controls, array("class" => "align_center", "colspan" => 2, "width" => "40%"));
	$table->construct_row();

	$query = $db->query("
		SELECT * FROM ".TABLE_PREFIX."icon_column
		ORDER BY `disporder` ASC
	");
	while($row = $db->fetch_array($query)) {
		$table->construct_cell("<b>".$row['id']."</b>");
		$table->construct_cell($row['title'], array("class" => "align_center"));
		$table->construct_cell($row['link'], array("class" => "align_center"));
		$table->construct_cell("{$img}".$row['icon']."\" >", array("class" => "align_center"));
		$table->construct_cell($row['disporder'], array("class" => "align_center"));
		$table->construct_cell("<a href=\"index.php?module=config-".$lang->ic_url."&amp;action=edit&amp;icid={$row['id']}\">{$img_edit}".$lang->ic_edit."</a>", array("class" => "align_center"));
		$table->construct_cell("<a href=\"index.php?module=config-".$lang->ic_url."&amp;action=delete&amp;icid={$row['id']}&amp;my_post_key={$mybb->post_code}\" onclick=\"return AdminCP.deleteConfirmation(this, '{$lang->ic_delete_onclick}')\">{$img_delete}".$lang->ic_delete."</a>", array("class" => "align_center"));
		$table->construct_row();
	}
	
	$table->output($lang->ic_icons);
	$page->output_footer();
}

function IconColumn_index( ) {
	global $mybb, $db, $icon_column;
	
	if ($mybb->settings['enabled_icon_column'] == 1) {
		$icon_column = "";
		$query = $db->query("
			SELECT * FROM ".TABLE_PREFIX."icon_column
			ORDER BY `disporder` ASC
		");
		while($row = $db->fetch_array($query)) {
			$icon_column .= '<li><a href="'.$row['link'].'" title="'.$row['title'].'" target="_blank"><img src="images/IconColumn/'.$row['icon'].'" /></a></li>';
		}
	}
}
?>